/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.geoip2.NetworkDeserializer;
import com.maxmind.geoip2.model.AbstractResponse;

public class AnonymousIpResponse
extends AbstractResponse {
    private final boolean isAnonymous;
    private final boolean isAnonymousVpn;
    private final boolean isHostingProvider;
    private final boolean isPublicProxy;
    private final boolean isResidentialProxy;
    private final boolean isTorExitNode;
    private final String ipAddress;
    private final Network network;

    AnonymousIpResponse() {
        this(null, false, false, false, false, false);
    }

    public AnonymousIpResponse(String ipAddress, boolean isAnonymous, boolean isAnonymousVpn, boolean isHostingProvider, boolean isPublicProxy, boolean isTorExitNode) {
        this(ipAddress, isAnonymous, isAnonymousVpn, isHostingProvider, isPublicProxy, isTorExitNode, null);
    }

    public AnonymousIpResponse(String ipAddress, boolean isAnonymous, boolean isAnonymousVpn, boolean isHostingProvider, boolean isPublicProxy, boolean isTorExitNode, Network network) {
        this(ipAddress, isAnonymous, isAnonymousVpn, isHostingProvider, isPublicProxy, false, isTorExitNode, network);
    }

    public AnonymousIpResponse(@JacksonInject(value="ip_address") @JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="is_anonymous") boolean isAnonymous, @JsonProperty(value="is_anonymous_vpn") boolean isAnonymousVpn, @JsonProperty(value="is_hosting_provider") boolean isHostingProvider, @JsonProperty(value="is_public_proxy") boolean isPublicProxy, @JsonProperty(value="is_residential_proxy") boolean isResidentialProxy, @JsonProperty(value="is_tor_exit_node") boolean isTorExitNode, @JacksonInject(value="network") @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network) {
        this.isAnonymous = isAnonymous;
        this.isAnonymousVpn = isAnonymousVpn;
        this.isHostingProvider = isHostingProvider;
        this.isPublicProxy = isPublicProxy;
        this.isResidentialProxy = isResidentialProxy;
        this.isTorExitNode = isTorExitNode;
        this.ipAddress = ipAddress;
        this.network = network;
    }

    @MaxMindDbConstructor
    public AnonymousIpResponse(@MaxMindDbParameter(name="ip_address") String ipAddress, @MaxMindDbParameter(name="is_anonymous") Boolean isAnonymous, @MaxMindDbParameter(name="is_anonymous_vpn") Boolean isAnonymousVpn, @MaxMindDbParameter(name="is_hosting_provider") Boolean isHostingProvider, @MaxMindDbParameter(name="is_public_proxy") Boolean isPublicProxy, @MaxMindDbParameter(name="is_residential_proxy") Boolean isResidentialProxy, @MaxMindDbParameter(name="is_tor_exit_node") Boolean isTorExitNode, @MaxMindDbParameter(name="network") Network network) {
        this(ipAddress, isAnonymous != null ? isAnonymous : false, isAnonymousVpn != null ? isAnonymousVpn : false, isHostingProvider != null ? isHostingProvider : false, isPublicProxy != null ? isPublicProxy : false, isResidentialProxy != null ? isResidentialProxy : false, isTorExitNode != null ? isTorExitNode : false, network);
    }

    public AnonymousIpResponse(AnonymousIpResponse response, String ipAddress, Network network) {
        this(ipAddress, response.isAnonymous(), response.isAnonymousVpn(), response.isHostingProvider(), response.isPublicProxy(), response.isResidentialProxy(), response.isTorExitNode(), network);
    }

    @JsonProperty(value="is_anonymous")
    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    @JsonProperty(value="is_anonymous_vpn")
    public boolean isAnonymousVpn() {
        return this.isAnonymousVpn;
    }

    @JsonProperty(value="is_hosting_provider")
    public boolean isHostingProvider() {
        return this.isHostingProvider;
    }

    @JsonProperty(value="is_public_proxy")
    public boolean isPublicProxy() {
        return this.isPublicProxy;
    }

    @JsonProperty(value="is_residential_proxy")
    public boolean isResidentialProxy() {
        return this.isResidentialProxy;
    }

    @JsonProperty(value="is_tor_exit_node")
    public boolean isTorExitNode() {
        return this.isTorExitNode;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network;
    }
}

