/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(IcmpMonitor.class);
    private Supplier<PingerFactory> pingerFactory = Suppliers.memoize(() -> (PingerFactory)BeanUtils.getBean((String)"daoContext", (String)"pingerFactory", PingerFactory.class));

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        Number rtt = null;
        InetAddress host = svc.getAddress();
        try {
            int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)2);
            long timeout = ParameterMap.getKeyedLong(parameters, (String)"timeout", (long)800L);
            int packetSize = ParameterMap.getKeyedInteger(parameters, (String)"packet-size", (int)64);
            int dscp = ParameterMap.getKeyedDecodedInteger(parameters, (String)"dscp", (int)0);
            boolean allowFragmentation = ParameterMap.getKeyedBoolean(parameters, (String)"allow-fragmentation", (boolean)true);
            rtt = ((PingerFactory)this.pingerFactory.get()).getInstance(dscp, allowFragmentation).ping(host, timeout, retries, packetSize);
        }
        catch (Throwable e) {
            LOG.debug("failed to ping {}", (Object)host, (Object)e);
            return PollStatus.unavailable((String)e.getMessage());
        }
        if (rtt != null) {
            return PollStatus.available((Double)rtt.doubleValue());
        }
        return PollStatus.unavailable(null);
    }

    public void setPingerFactory(PingerFactory pingerFactory) {
        this.pingerFactory = Suppliers.ofInstance((Object)pingerFactory);
    }
}

