/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.datablock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.eventd.datablock.EventMaskValueList;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Varbind;

public class EventKey
extends LinkedHashMap<Entity, Object>
implements Serializable,
Comparable<EventKey> {
    private static final long serialVersionUID = 3498941419429346315L;
    public static final String TAG_UEI = "uei";
    public static final String TAG_SOURCE = "source";
    public static final String TAG_NODEID = "nodeid";
    public static final String TAG_HOST = "host";
    public static final String TAG_INTERFACE = "interface";
    public static final String TAG_SNMPHOST = "snmphost";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_SNMP_EID = "id";
    public static final String TAG_SNMP_TRAPOID = "trapoid";
    public static final String TAG_SNMP_SPECIFIC = "specific";
    public static final String TAG_SNMP_GENERIC = "generic";
    public static final String TAG_SNMP_COMMUNITY = "community";
    private int m_hashCode;

    public EventKey() {
        this.m_hashCode = -1111;
    }

    public EventKey(int initCapacity) {
        super(initCapacity);
        this.m_hashCode = -1111;
    }

    public EventKey(int initCapacity, float loadFactor) {
        super(initCapacity, loadFactor);
        this.m_hashCode = -1111;
    }

    public EventKey(Map<Entity, Object> maskelements) {
        super(maskelements);
        this.m_hashCode = 1;
        this.evaluateHashCode();
    }

    public EventKey(Event event) {
        this.m_hashCode = 1;
        Mask mask = event.getMask();
        if (mask == null || mask.getMaskelements().size() == 0) {
            String uei = event.getUei();
            if (uei != null) {
                this.put(new Entity(Type.TAG, TAG_UEI), (Object)new EventMaskValueList(uei));
            }
        } else {
            for (Maskelement maskelement : mask.getMaskelements()) {
                String name = maskelement.getMename();
                EventMaskValueList value = new EventMaskValueList();
                for (String mevalue : maskelement.getMevalues()) {
                    value.add(mevalue);
                }
                this.put(new Entity(Type.TAG, name), (Object)value);
            }
            if (mask != null && mask.getVarbinds().size() != 0) {
                for (Varbind varbind : mask.getVarbinds()) {
                    EventMaskValueList vbvalues = new EventMaskValueList();
                    vbvalues.addAll((Collection<? extends String>)varbind.getVbvalues());
                    if (varbind.getVbnumber() != null) {
                        this.put(new Entity(Type.VBNUMBER, varbind.getVbnumber().toString()), (Object)vbvalues);
                        continue;
                    }
                    this.put(new Entity(Type.VBOID, varbind.getVboid()), (Object)vbvalues);
                }
            }
        }
    }

    public EventKey(org.opennms.netmgt.xml.event.Event event) {
        this.m_hashCode = 1;
        org.opennms.netmgt.xml.event.Mask mask = event.getMask();
        if (mask == null || mask.getMaskelementCount() == 0) {
            String uei = event.getUei();
            if (uei != null) {
                this.put(new Entity(Type.TAG, TAG_UEI), (Object)uei);
            }
        } else {
            for (org.opennms.netmgt.xml.event.Maskelement maskelement : mask.getMaskelementCollection()) {
                String name = maskelement.getMename();
                String value = EventKey.getMaskElementValue(event, new Entity(Type.TAG, name));
                this.put(new Entity(Type.TAG, name), (Object)value);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.evaluateHashCode();
    }

    @Override
    public Object put(Entity key, Object value) {
        Object ret = super.put(key, value);
        this.evaluateHashCode();
        return ret;
    }

    @Override
    public void putAll(Map<? extends Entity, ? extends Object> m) {
        super.putAll(m);
        this.evaluateHashCode();
    }

    @Override
    public Object remove(Object key) {
        Object ret = super.remove(key);
        this.evaluateHashCode();
        return ret;
    }

    private void evaluateHashCode() {
        this.m_hashCode = 0;
        if (this.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.entrySet()) {
            Entity key = (Entity)entry.getKey();
            Object value = entry.getValue();
            this.m_hashCode += key == null ? 0 : key.hashCode();
            this.m_hashCode += value == null ? 0 : value.hashCode();
        }
    }

    @Override
    public int compareTo(EventKey obj) {
        return this.hashCode() - obj.hashCode();
    }

    @Override
    public int hashCode() {
        if (this.m_hashCode != -1111) {
            return this.m_hashCode;
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("EventKey\n[\n\t");
        for (Map.Entry e : this.entrySet()) {
            s.append(String.valueOf(e.getKey()) + "    = " + e.getValue().toString() + "\n\t");
        }
        s.append("\n]\n");
        return s.toString();
    }

    public static String getMaskElementValue(org.opennms.netmgt.xml.event.Event event, Entity mename) {
        String retParmVal;
        block33: {
            block34: {
                block32: {
                    retParmVal = null;
                    if (mename.type != Type.TAG) break block32;
                    switch (mename.key) {
                        case "uei": {
                            retParmVal = event.getUei();
                            break;
                        }
                        case "source": {
                            retParmVal = event.getSource();
                            break;
                        }
                        case "nodeid": {
                            retParmVal = Long.toString(event.getNodeid());
                            break;
                        }
                        case "host": {
                            retParmVal = event.getHost();
                            break;
                        }
                        case "interface": {
                            retParmVal = event.getInterface();
                            break;
                        }
                        case "snmphost": {
                            retParmVal = event.getSnmphost();
                            break;
                        }
                        case "service": {
                            retParmVal = event.getService();
                            break;
                        }
                        case "id": {
                            if (event.getSnmp() == null) break;
                            retParmVal = event.getSnmp().getId();
                            break;
                        }
                        case "trapoid": {
                            if (event.getSnmp() == null || !event.getSnmp().hasTrapOID()) break;
                            retParmVal = event.getSnmp().getTrapOID();
                            break;
                        }
                        case "specific": {
                            Snmp eventSnmpInfo = event.getSnmp();
                            if (eventSnmpInfo != null && eventSnmpInfo.hasSpecific()) {
                                retParmVal = Integer.toString(eventSnmpInfo.getSpecific());
                                break;
                            }
                            break block33;
                        }
                        case "generic": {
                            Snmp eventSnmpInfo = event.getSnmp();
                            if (eventSnmpInfo != null && eventSnmpInfo.hasGeneric()) {
                                retParmVal = Integer.toString(eventSnmpInfo.getGeneric());
                                break;
                            }
                            break block33;
                        }
                        case "community": {
                            Snmp eventSnmpInfo = event.getSnmp();
                            if (eventSnmpInfo == null) break;
                            retParmVal = eventSnmpInfo.getCommunity();
                        }
                    }
                    break block33;
                }
                if (event.getParmCollection().isEmpty()) break block33;
                if (mename.type != Type.VBNUMBER) break block34;
                ArrayList<String> eventparms = new ArrayList<String>();
                for (Parm evParm : event.getParmCollection()) {
                    eventparms.add(EventConstants.getValueAsString((Value)evParm.getValue()));
                }
                int vbnumber = Integer.parseInt(mename.key);
                if (vbnumber <= 0 || vbnumber > eventparms.size()) break block33;
                retParmVal = (String)eventparms.get(vbnumber - 1);
                break block33;
            }
            ArrayList eventParms = new ArrayList();
            for (Parm eventParameter : event.getParmCollection()) {
                String oid = eventParameter.getParmName();
                if (oid == null || !oid.equals(mename.key)) continue;
                retParmVal = EventConstants.getValueAsString((Value)eventParameter.getValue());
                break;
            }
        }
        return retParmVal;
    }

    public static class Entity {
        private final Type type;
        private final String key;

        public Entity(Type type, String key) {
            this.type = type;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity entity = (Entity)o;
            return this.type == entity.type && Objects.equals(this.key, entity.key);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.key});
        }
    }

    static enum Type {
        TAG,
        VBNUMBER,
        VBOID;

    }
}

