/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.translator.Assignment;

@XmlRootElement(name="mapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="translator-configuration.xsd")
public class Mapping
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="preserve-snmp-data")
    private Boolean m_preserveSnmpData;
    @XmlElement(name="assignment")
    private List<Assignment> m_assignments = new ArrayList<Assignment>();

    public Boolean getPreserveSnmpData() {
        return this.m_preserveSnmpData != null ? this.m_preserveSnmpData : Boolean.FALSE;
    }

    public void setPreserveSnmpData(Boolean preserveSnmpData) {
        this.m_preserveSnmpData = preserveSnmpData;
    }

    public List<Assignment> getAssignments() {
        return this.m_assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        if (assignments == this.m_assignments) {
            return;
        }
        this.m_assignments.clear();
        if (assignments != null) {
            this.m_assignments.addAll(assignments);
        }
    }

    public void addAssignment(Assignment assignment) {
        this.m_assignments.add(assignment);
    }

    public boolean removeAssignment(Assignment assignment) {
        return this.m_assignments.remove(assignment);
    }

    public int hashCode() {
        return Objects.hash(this.m_preserveSnmpData, this.m_assignments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mapping) {
            Mapping that = (Mapping)obj;
            return Objects.equals(this.m_preserveSnmpData, that.m_preserveSnmpData) && Objects.equals(this.m_assignments, that.m_assignments);
        }
        return false;
    }
}

