/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.scriptd;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="engine")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="scriptd-configuration.xsd")
public class Engine
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="language", required=true)
    private String m_language;
    @XmlAttribute(name="className", required=true)
    private String m_className;
    @XmlAttribute(name="extensions")
    private String m_extensions;

    public String getLanguage() {
        return this.m_language;
    }

    public void setLanguage(String language) {
        this.m_language = ConfigUtils.assertNotEmpty(language, "language");
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = ConfigUtils.assertNotEmpty(className, "className");
    }

    public Optional<String> getExtensions() {
        return Optional.ofNullable(this.m_extensions);
    }

    public void setExtensions(String extensions) {
        this.m_extensions = ConfigUtils.normalizeString(extensions);
    }

    public int hashCode() {
        return Objects.hash(this.m_language, this.m_className, this.m_extensions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Engine) {
            Engine that = (Engine)obj;
            return Objects.equals(this.m_language, that.m_language) && Objects.equals(this.m_className, that.m_className) && Objects.equals(this.m_extensions, that.m_extensions);
        }
        return false;
    }
}

