/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.AutoAcknowledgeAlarm;
import org.opennms.netmgt.config.notifd.Queue;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="notifd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="notifd-configuration.xsd")
public class NotifdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_PAGES_SENT = "SELECT * FROM notifications";
    private static final String DEFAULT_NEXT_NOTIFID = "SELECT nextval('notifynxtid')";
    private static final String DEFAULT_NEXT_USER_NOTIFID = "SELECT nextval('userNotifNxtId')";
    private static final String DEFAULT_NEXT_GROUP_ID = "SELECT nextval('notifygrpid')";
    private static final String DEFAULT_SERVICEID_SQL = "SELECT serviceID from service where serviceName = ?";
    private static final String DEFAULT_OUTSTANDING_NOTICES_SQL = "SELECT notifyid FROM notifications where notifyId = ? AND respondTime is not null";
    private static final String DEFAULT_ACKNOWLEDGEID_SQL = "SELECT notifyid FROM notifications WHERE eventuei=? AND nodeid=? AND interfaceid=? AND serviceid=?";
    private static final String DEFAULT_ACKNOWLEDGE_UPDATE_SQL = "UPDATE notifications SET answeredby=?, respondtime=? WHERE notifyId=?";
    private static final String DEFAULT_EMAIL_ADDRESS_COMMAND = "javaEmail";
    private static final Integer DEFAULT_MAX_THREADS = 100;
    @XmlAttribute(name="status", required=true)
    private String m_status;
    @XmlAttribute(name="pages-sent")
    private String m_pagesSent;
    @XmlAttribute(name="next-notif-id")
    private String m_nextNotifId;
    @XmlAttribute(name="next-user-notif-id")
    private String m_nextUserNotifId;
    @XmlAttribute(name="next-group-id")
    private String m_nextGroupId;
    @XmlAttribute(name="service-id-sql")
    private String m_serviceIdSql;
    @XmlAttribute(name="outstanding-notices-sql")
    private String m_outstandingNoticesSql;
    @XmlAttribute(name="acknowledge-id-sql")
    private String m_acknowledgeIdSql;
    @XmlAttribute(name="acknowledge-update-sql")
    private String m_acknowledgeUpdateSql;
    @XmlAttribute(name="match-all", required=true)
    private Boolean m_matchAll;
    @XmlAttribute(name="email-address-command")
    private String m_emailAddressCommand;
    @XmlAttribute(name="numeric-skip-resolution-prefix")
    private Boolean m_numericSkipResolutionPrefix;
    @XmlAttribute(name="max-threads")
    private Integer m_maxThreads;
    @XmlElement(name="auto-acknowledge-alarm")
    private AutoAcknowledgeAlarm m_autoAcknowledgeAlarm;
    @XmlElement(name="auto-acknowledge")
    private List<AutoAcknowledge> m_autoAcknowledges = new ArrayList<AutoAcknowledge>();
    @XmlElement(name="queue", required=true)
    private List<Queue> m_queues = new ArrayList<Queue>();
    @XmlElement(name="outage-calendar")
    private List<String> m_outageCalendars = new ArrayList<String>();

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = ConfigUtils.assertNotEmpty(status, "status");
    }

    public String getPagesSent() {
        return this.m_pagesSent != null ? this.m_pagesSent : DEFAULT_PAGES_SENT;
    }

    public void setPagesSent(String pagesSent) {
        this.m_pagesSent = ConfigUtils.normalizeString(pagesSent);
    }

    public String getNextNotifId() {
        return this.m_nextNotifId != null ? this.m_nextNotifId : DEFAULT_NEXT_NOTIFID;
    }

    public void setNextNotifId(String nextNotifId) {
        this.m_nextNotifId = ConfigUtils.normalizeString(nextNotifId);
    }

    public String getNextUserNotifId() {
        return this.m_nextUserNotifId != null ? this.m_nextUserNotifId : DEFAULT_NEXT_USER_NOTIFID;
    }

    public void setNextUserNotifId(String nextUserNotifId) {
        this.m_nextUserNotifId = ConfigUtils.normalizeString(nextUserNotifId);
    }

    public String getNextGroupId() {
        return this.m_nextGroupId != null ? this.m_nextGroupId : DEFAULT_NEXT_GROUP_ID;
    }

    public void setNextGroupId(String nextGroupId) {
        this.m_nextGroupId = ConfigUtils.normalizeString(nextGroupId);
    }

    public String getServiceIdSql() {
        return this.m_serviceIdSql != null ? this.m_serviceIdSql : DEFAULT_SERVICEID_SQL;
    }

    public void setServiceIdSql(String serviceIdSql) {
        this.m_serviceIdSql = ConfigUtils.normalizeString(serviceIdSql);
    }

    public String getOutstandingNoticesSql() {
        return this.m_outstandingNoticesSql != null ? this.m_outstandingNoticesSql : DEFAULT_OUTSTANDING_NOTICES_SQL;
    }

    public void setOutstandingNoticesSql(String outstandingNoticesSql) {
        this.m_outstandingNoticesSql = ConfigUtils.normalizeString(outstandingNoticesSql);
    }

    public String getAcknowledgeIdSql() {
        return this.m_acknowledgeIdSql != null ? this.m_acknowledgeIdSql : DEFAULT_ACKNOWLEDGEID_SQL;
    }

    public void setAcknowledgeIdSql(String acknowledgeIdSql) {
        this.m_acknowledgeIdSql = ConfigUtils.normalizeString(acknowledgeIdSql);
    }

    public String getAcknowledgeUpdateSql() {
        return this.m_acknowledgeUpdateSql != null ? this.m_acknowledgeUpdateSql : DEFAULT_ACKNOWLEDGE_UPDATE_SQL;
    }

    public void setAcknowledgeUpdateSql(String acknowledgeUpdateSql) {
        this.m_acknowledgeUpdateSql = ConfigUtils.normalizeString(acknowledgeUpdateSql);
    }

    public Boolean getMatchAll() {
        return this.m_matchAll;
    }

    public void setMatchAll(Boolean matchAll) {
        this.m_matchAll = ConfigUtils.assertNotNull(matchAll, "match-all");
    }

    public String getEmailAddressCommand() {
        return this.m_emailAddressCommand != null ? this.m_emailAddressCommand : DEFAULT_EMAIL_ADDRESS_COMMAND;
    }

    public void setEmailAddressCommand(String emailAddressCommand) {
        this.m_emailAddressCommand = ConfigUtils.normalizeString(emailAddressCommand);
    }

    public Boolean getNumericSkipResolutionPrefix() {
        return this.m_numericSkipResolutionPrefix != null ? this.m_numericSkipResolutionPrefix : Boolean.valueOf("false");
    }

    public void setNumericSkipResolutionPrefix(Boolean prefix) {
        this.m_numericSkipResolutionPrefix = prefix;
    }

    public Integer getMaxThreads() {
        return this.m_maxThreads != null ? this.m_maxThreads : DEFAULT_MAX_THREADS;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.m_maxThreads = maxThreads;
    }

    public Optional<AutoAcknowledgeAlarm> getAutoAcknowledgeAlarm() {
        return Optional.ofNullable(this.m_autoAcknowledgeAlarm);
    }

    public void setAutoAcknowledgeAlarm(AutoAcknowledgeAlarm autoAcknowledgeAlarm) {
        this.m_autoAcknowledgeAlarm = autoAcknowledgeAlarm;
    }

    public List<AutoAcknowledge> getAutoAcknowledges() {
        return this.m_autoAcknowledges;
    }

    public void setAutoAcknowledges(List<AutoAcknowledge> autoAcknowledges) {
        this.m_autoAcknowledges.clear();
        this.m_autoAcknowledges.addAll(autoAcknowledges);
    }

    public void addAutoAcknowledge(AutoAcknowledge autoAcknowledge) throws IndexOutOfBoundsException {
        this.m_autoAcknowledges.add(autoAcknowledge);
    }

    public List<String> getOutageCalendars() {
        return this.m_outageCalendars;
    }

    public void setOutageCalendars(List<String> calendars) {
        if (calendars == this.m_outageCalendars) {
            return;
        }
        this.m_outageCalendars.clear();
        if (calendars != null) {
            this.m_outageCalendars.addAll(calendars);
        }
    }

    public void addOutageCalendar(String calendar) {
        this.m_outageCalendars.add(calendar);
    }

    public boolean removeOutageCalendar(String calendar) {
        return this.m_outageCalendars.remove(calendar);
    }

    public List<Queue> getQueues() {
        return this.m_queues;
    }

    public void setQueues(List<Queue> queues) {
        if (queues == this.m_queues) {
            return;
        }
        this.m_queues.clear();
        if (queues != null) {
            this.m_queues.addAll(queues);
        }
    }

    public void addQueue(Queue queue) {
        this.m_queues.add(queue);
    }

    public int hashCode() {
        return Objects.hash(this.m_status, this.m_pagesSent, this.m_nextNotifId, this.m_nextUserNotifId, this.m_nextGroupId, this.m_serviceIdSql, this.m_outstandingNoticesSql, this.m_acknowledgeIdSql, this.m_acknowledgeUpdateSql, this.m_matchAll, this.m_emailAddressCommand, this.m_numericSkipResolutionPrefix, this.m_maxThreads, this.m_autoAcknowledgeAlarm, this.m_autoAcknowledges, this.m_queues, this.m_outageCalendars);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotifdConfiguration) {
            NotifdConfiguration that = (NotifdConfiguration)obj;
            return Objects.equals(this.m_status, that.m_status) && Objects.equals(this.m_pagesSent, that.m_pagesSent) && Objects.equals(this.m_nextNotifId, that.m_nextNotifId) && Objects.equals(this.m_nextUserNotifId, that.m_nextUserNotifId) && Objects.equals(this.m_nextGroupId, that.m_nextGroupId) && Objects.equals(this.m_serviceIdSql, that.m_serviceIdSql) && Objects.equals(this.m_outstandingNoticesSql, that.m_outstandingNoticesSql) && Objects.equals(this.m_acknowledgeIdSql, that.m_acknowledgeIdSql) && Objects.equals(this.m_acknowledgeUpdateSql, that.m_acknowledgeUpdateSql) && Objects.equals(this.m_matchAll, that.m_matchAll) && Objects.equals(this.m_emailAddressCommand, that.m_emailAddressCommand) && Objects.equals(this.m_numericSkipResolutionPrefix, that.m_numericSkipResolutionPrefix) && Objects.equals(this.m_maxThreads, that.m_maxThreads) && Objects.equals(this.m_autoAcknowledgeAlarm, that.m_autoAcknowledgeAlarm) && Objects.equals(this.m_autoAcknowledges, that.m_autoAcknowledges) && Objects.equals(this.m_queues, that.m_queues) && Objects.equals(this.m_outageCalendars, that.m_outageCalendars);
        }
        return false;
    }
}

