/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.kscReports;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="Graph")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ksc-performance-reports.xsd")
public class Graph
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="title", required=true)
    private String m_title;
    @XmlAttribute(name="resourceId")
    private String m_resourceId;
    @XmlAttribute(name="nodeId")
    private String m_nodeId;
    @XmlAttribute(name="nodeSource")
    private String m_nodeSource;
    @XmlAttribute(name="domain")
    private String m_domain;
    @XmlAttribute(name="interfaceId")
    private String m_interfaceId;
    @XmlAttribute(name="timespan", required=true)
    private String m_timespan;
    @XmlAttribute(name="graphtype", required=true)
    private String m_graphtype;
    @XmlAttribute(name="extlink")
    private String m_extlink;

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = ConfigUtils.assertNotNull(title, "title");
    }

    public Optional<String> getResourceId() {
        return Optional.ofNullable(this.m_resourceId);
    }

    public void setResourceId(String resourceId) {
        this.m_resourceId = ConfigUtils.normalizeString(resourceId);
    }

    public Optional<String> getNodeId() {
        return Optional.ofNullable(this.m_nodeId);
    }

    public void setNodeId(String nodeId) {
        this.m_nodeId = ConfigUtils.normalizeString(nodeId);
    }

    public Optional<String> getNodeSource() {
        return Optional.ofNullable(this.m_nodeSource);
    }

    public void setNodeSource(String nodeSource) {
        this.m_nodeSource = ConfigUtils.normalizeString(nodeSource);
    }

    public Optional<String> getDomain() {
        return Optional.ofNullable(this.m_domain);
    }

    public void setDomain(String domain) {
        this.m_domain = ConfigUtils.normalizeString(domain);
    }

    public Optional<String> getInterfaceId() {
        return Optional.ofNullable(this.m_interfaceId);
    }

    public void setInterfaceId(String interfaceId) {
        this.m_interfaceId = ConfigUtils.normalizeString(interfaceId);
    }

    public String getTimespan() {
        return this.m_timespan;
    }

    public void setTimespan(String timespan) {
        this.m_timespan = ConfigUtils.assertNotEmpty(timespan, "timespan");
    }

    public String getGraphtype() {
        return this.m_graphtype;
    }

    public void setGraphtype(String graphtype) {
        this.m_graphtype = ConfigUtils.assertNotEmpty(graphtype, "graphtype");
    }

    public Optional<String> getExtlink() {
        return Optional.ofNullable(this.m_extlink);
    }

    public void setExtlink(String extlink) {
        this.m_extlink = ConfigUtils.normalizeString(extlink);
    }

    public int hashCode() {
        return Objects.hash(this.m_title, this.m_resourceId, this.m_nodeId, this.m_nodeSource, this.m_domain, this.m_interfaceId, this.m_timespan, this.m_graphtype, this.m_extlink);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Graph) {
            Graph that = (Graph)obj;
            return Objects.equals(this.m_title, that.m_title) && Objects.equals(this.m_resourceId, that.m_resourceId) && Objects.equals(this.m_nodeId, that.m_nodeId) && Objects.equals(this.m_nodeSource, that.m_nodeSource) && Objects.equals(this.m_domain, that.m_domain) && Objects.equals(this.m_interfaceId, that.m_interfaceId) && Objects.equals(this.m_timespan, that.m_timespan) && Objects.equals(this.m_graphtype, that.m_graphtype) && Objects.equals(this.m_extlink, that.m_extlink);
        }
        return false;
    }
}

