/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.eventd;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="EventdConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventd-configuration.xsd")
public class EventdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUM_THREADS = 0;
    private static final int BATCH_SIZE = 1000;
    private static final int BATCH_INTERVAL = 500;
    private static final int QUEUE_SIZE = 10000;
    @XmlAttribute(name="TCPAddress")
    private String m_tcpAddress = "127.0.0.1";
    @XmlAttribute(name="TCPPort", required=true)
    private Integer m_tcpPort;
    @XmlAttribute(name="UDPAddress")
    private String m_udpAddress = "127.0.0.1";
    @XmlAttribute(name="UDPPort", required=true)
    private Integer m_udpPort;
    @XmlAttribute(name="receivers", required=true)
    private Integer m_receivers;
    @XmlAttribute(name="queueLength")
    private Integer m_queueLength;
    @XmlAttribute(name="getNextEventID")
    private String m_getNextEventID;
    @XmlAttribute(name="socketSoTimeoutRequired", required=true)
    private String m_socketSoTimeoutRequired;
    @XmlAttribute(name="socketSoTimeoutPeriod")
    private Integer m_socketSoTimeoutPeriod;
    @XmlAttribute(name="logEventSummaries")
    private Boolean m_logEventSummaries;
    @XmlValue
    private String m_contents;
    @XmlAttribute(name="sink-threads", required=false)
    private Integer m_threads;
    @XmlAttribute(name="sink-queue-size", required=false)
    private Integer m_queueSize;
    @XmlAttribute(name="sink-batch-size", required=false)
    private Integer m_batchSize;
    @XmlAttribute(name="sink-batch-interval", required=false)
    private Integer m_batchInterval;

    public Optional<String> getTCPAddress() {
        return Optional.ofNullable(this.m_tcpAddress);
    }

    public void setTCPAddress(String TCPAddress) {
        this.m_tcpAddress = ConfigUtils.normalizeString(TCPAddress);
    }

    public Integer getTCPPort() {
        return this.m_tcpPort;
    }

    public void setTCPPort(Integer TCPPort) {
        this.m_tcpPort = ConfigUtils.assertNotNull(TCPPort, "TCPPort");
    }

    public Optional<String> getUDPAddress() {
        return Optional.ofNullable(this.m_udpAddress);
    }

    public void setUDPAddress(String UDPAddress) {
        this.m_udpAddress = ConfigUtils.normalizeString(UDPAddress);
    }

    public Integer getUDPPort() {
        return this.m_udpPort;
    }

    public void setUDPPort(Integer UDPPort) {
        this.m_udpPort = ConfigUtils.assertNotNull(UDPPort, "UDPPort");
    }

    public Integer getNumThreads() {
        return this.m_threads == null ? 0 : this.m_threads;
    }

    public void setNumThreads(Integer numThreads) {
        this.m_threads = numThreads;
    }

    public Integer getReceivers() {
        return this.m_receivers;
    }

    public void setReceivers(Integer receivers) {
        this.m_receivers = ConfigUtils.assertNotNull(receivers, "receivers");
    }

    public Optional<Integer> getQueueLength() {
        return Optional.ofNullable(this.m_queueLength);
    }

    public void setQueueLength(Integer queueLength) {
        this.m_queueLength = queueLength;
    }

    public Optional<String> getGetNextEventID() {
        return Optional.ofNullable(this.m_getNextEventID);
    }

    public void setGetNextEventID(String getNextEventID) {
        this.m_getNextEventID = ConfigUtils.normalizeString(getNextEventID);
    }

    public String getSocketSoTimeoutRequired() {
        return this.m_socketSoTimeoutRequired;
    }

    public void setSocketSoTimeoutRequired(String socketSoTimeoutRequired) {
        this.m_socketSoTimeoutRequired = ConfigUtils.assertNotNull(socketSoTimeoutRequired, "socketSoTimeoutRequired");
    }

    public Optional<Integer> getSocketSoTimeoutPeriod() {
        return Optional.ofNullable(this.m_socketSoTimeoutPeriod);
    }

    public void setSocketSoTimeoutPeriod(Integer socketSoTimeoutPeriod) {
        this.m_socketSoTimeoutPeriod = socketSoTimeoutPeriod;
    }

    public Boolean getLogEventSummaries() {
        return this.m_logEventSummaries != null ? this.m_logEventSummaries : true;
    }

    public void setLogEventSummaries(Boolean logEventSummaries) {
        this.m_logEventSummaries = logEventSummaries;
    }

    public int getQueueSize() {
        return this.m_queueSize == null ? 10000 : this.m_queueSize;
    }

    public void setQueueSize(int _queueSize) {
        this.m_queueSize = _queueSize;
    }

    public int getBatchSize() {
        return this.m_batchSize == null ? 1000 : this.m_batchSize;
    }

    public void setBatchSize(int _batchSize) {
        this.m_batchSize = _batchSize;
    }

    public int getBatchInterval() {
        return this.m_batchInterval == null ? 500 : this.m_batchInterval;
    }

    public void setBatchInterval(int _batchInterval) {
        this.m_batchInterval = _batchInterval;
    }

    public int hashCode() {
        return Objects.hash(this.m_tcpAddress, this.m_tcpPort, this.m_udpAddress, this.m_udpPort, this.m_receivers, this.m_queueLength, this.m_getNextEventID, this.m_socketSoTimeoutRequired, this.m_socketSoTimeoutPeriod, this.m_logEventSummaries, this.m_threads, this.m_queueSize, this.m_batchSize, this.m_batchInterval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventdConfiguration) {
            EventdConfiguration that = (EventdConfiguration)obj;
            return Objects.equals(this.m_tcpAddress, that.m_tcpAddress) && Objects.equals(this.m_tcpPort, that.m_tcpPort) && Objects.equals(this.m_udpAddress, that.m_udpAddress) && Objects.equals(this.m_udpPort, that.m_udpPort) && Objects.equals(this.m_receivers, that.m_receivers) && Objects.equals(this.m_queueLength, that.m_queueLength) && Objects.equals(this.m_getNextEventID, that.m_getNextEventID) && Objects.equals(this.m_socketSoTimeoutRequired, that.m_socketSoTimeoutRequired) && Objects.equals(this.m_socketSoTimeoutPeriod, that.m_socketSoTimeoutPeriod) && Objects.equals(this.m_logEventSummaries, that.m_logEventSummaries) && Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_queueSize, that.m_queueSize) && Objects.equals(this.m_batchSize, that.m_batchSize) && Objects.equals(this.m_batchInterval, that.m_batchInterval);
        }
        return false;
    }
}

