/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class JiraClientUtils {
    public static List<CimProject> getIssueMetaData(JiraRestClient client, String expandos, String issueTypeName, String projectKey) throws ExecutionException, InterruptedException {
        return Lists.newArrayList((Iterable)((Iterable)client.getIssueClient().getCreateIssueMetadata(new GetCreateIssueMetadataOptions((Iterable)(expandos == null ? null : Lists.newArrayList((Object[])new String[]{expandos})), (Iterable)(issueTypeName == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeName})), null, projectKey == null ? null : Lists.newArrayList((Object[])new String[]{projectKey}), null)).get()));
    }

    public static List<CimProject> getIssueMetaData(JiraRestClient client, String expandos, Long issueTypeId, String projectKey) throws ExecutionException, InterruptedException {
        return Lists.newArrayList((Iterable)((Iterable)client.getIssueClient().getCreateIssueMetadata(new GetCreateIssueMetadataOptions((Iterable)(expandos == null ? null : Lists.newArrayList((Object[])new String[]{expandos})), null, (Iterable)(issueTypeId == null ? null : Lists.newArrayList((Object[])new Long[]{issueTypeId})), projectKey == null ? null : Lists.newArrayList((Object[])new String[]{projectKey}), null)).get()));
    }

    public static Collection<CimFieldInfo> getFields(List<CimProject> cimProjects) {
        Map fields;
        if (cimProjects != null && !cimProjects.isEmpty() && cimProjects.get(0).getIssueTypes().iterator().hasNext() && (fields = ((CimIssueType)cimProjects.get(0).getIssueTypes().iterator().next()).getFields()) != null) {
            return fields.values();
        }
        return Lists.newArrayList();
    }

    public static Iterable<? extends IssueType> getIssueTypes(JiraRestClient client, String projectKey) throws ExecutionException, InterruptedException {
        if (Strings.isNullOrEmpty((String)projectKey)) {
            return (Iterable)client.getMetadataClient().getIssueTypes().get();
        }
        List<CimProject> cimProjects = JiraClientUtils.getIssueMetaData(client, null, (String)null, projectKey);
        if (cimProjects.iterator().hasNext()) {
            return ((CimProject)cimProjects.iterator().next()).getIssueTypes();
        }
        return Lists.newArrayList();
    }
}

