/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.spog;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.opennms.features.grpc.exporter.Callback;
import org.opennms.features.grpc.exporter.GrpcClient;
import org.opennms.features.grpc.exporter.NamedThreadFactory;
import org.opennms.plugin.grpc.proto.spog.AlarmUpdateList;
import org.opennms.plugin.grpc.proto.spog.EventUpdateList;
import org.opennms.plugin.grpc.proto.spog.HeartBeat;
import org.opennms.plugin.grpc.proto.spog.NmsInventoryServiceSyncGrpc;
import org.opennms.plugin.grpc.proto.spog.NmsInventoryUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpogGrpcClient
extends GrpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(SpogGrpcClient.class);
    private final String threadName = "alarm-inventory-grpc-connect";
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("alarm-inventory-grpc-connect"));
    private NmsInventoryServiceSyncGrpc.NmsInventoryServiceSyncStub nmsSyncStub;
    private StreamObserver<AlarmUpdateList> alarmsUpdateStream;
    private StreamObserver<NmsInventoryUpdateList> nmsInventoryUpdateStream;
    private StreamObserver<EventUpdateList> eventUpdateStream;
    private StreamObserver<HeartBeat> heartBeatUpdateStream;
    private boolean enabled = true;
    private Callback inventoryCallback;

    public SpogGrpcClient(String host, String tlsCertPath, boolean tlsEnabled, ClientInterceptor clientInterceptor) {
        super(host, tlsCertPath, tlsEnabled, clientInterceptor);
    }

    public void start() throws SSLException {
        if (!this.enabled) {
            LOG.info("SPOG GrpcClient disabled, not starting connections to {}", (Object)super.getHost());
            return;
        }
        super.startGrpcConnection();
        this.nmsSyncStub = NmsInventoryServiceSyncGrpc.newStub((Channel)super.getChannel());
        this.connectStreams();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void connectStreams() {
        this.scheduler.scheduleAtFixedRate(this::initializeStreams, 30L, 30L, TimeUnit.SECONDS);
    }

    private synchronized void initializeStreams() {
        if (super.getChannelState().equals((Object)ConnectivityState.READY)) {
            try {
                this.alarmsUpdateStream = this.nmsSyncStub.alarmUpdate(new LoggingAckReceiver("spog_alarm_update", this));
                this.nmsInventoryUpdateStream = this.nmsSyncStub.inventoryUpdate(new LoggingAckReceiver("spog_inventory_update", this));
                this.eventUpdateStream = this.nmsSyncStub.eventUpdate(new LoggingAckReceiver("spog_events_update", this));
                this.heartBeatUpdateStream = this.nmsSyncStub.heartBeatUpdate(new LoggingAckReceiver("spog_heartbeat_update", this));
                this.scheduler.shutdown();
                this.scheduler = null;
                LOG.info("SPOG Streams initialized successfully.");
                this.reconnecting.set(false);
                if (this.inventoryCallback != null) {
                    this.inventoryCallback.sendInventorySnapShot();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to initialize NMS streams", (Throwable)e);
            }
        } else {
            LOG.info("GRPC-Channel state is not READY, retrying... {}", (Object)super.getHost());
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        super.stopGrpcConnection();
    }

    private synchronized void reconnectStreams() {
        if (this.reconnecting.compareAndSet(false, true) && !super.getStopped() && (this.scheduler == null || this.scheduler.isShutdown())) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("alarm-inventory-grpc-connect"));
            this.scheduler.scheduleAtFixedRate(this::initializeStreams, 30L, 30L, TimeUnit.SECONDS);
        }
    }

    public void setInventoryCallback(Callback inventoryCallback) {
        this.inventoryCallback = inventoryCallback;
    }

    public void sendAlarmUpdate(AlarmUpdateList alarmUpdates) {
        if (this.alarmsUpdateStream != null) {
            this.alarmsUpdateStream.onNext((Object)alarmUpdates);
            LOG.info("SPOG-Sent an alarm-Updates with {} count", (Object)alarmUpdates.getAlarmsCount());
        } else {
            LOG.warn("SPOG-Unable to send alarm-Updates since channel is not ready yet .. {} ", (Object)super.getHost());
        }
    }

    public void sendNmsInventoryUpdate(NmsInventoryUpdateList updates) {
        if (this.nmsInventoryUpdateStream != null) {
            this.nmsInventoryUpdateStream.onNext((Object)updates);
            LOG.info("SPOG-Sent an inventory update with {} nodes", (Object)updates.getNodesCount());
        } else {
            LOG.warn("SPOG-Unable to send Inventory-Updates since channel is not ready yet .. {} ", (Object)super.getHost());
        }
    }

    public void sendEventUpdate(EventUpdateList updates) {
        if (this.eventUpdateStream != null) {
            this.eventUpdateStream.onNext((Object)updates);
            LOG.info("SPOG-Sent an Event-Update with {} count", (Object)updates.getEventCount());
        } else {
            LOG.warn("SPOG-Unable to send Event-Updates since channel is not ready yet .. {} ", (Object)super.getHost());
        }
    }

    public void sendHeartBeatUpdate(HeartBeat heartBeat) {
        if (this.heartBeatUpdateStream != null) {
            this.heartBeatUpdateStream.onNext((Object)heartBeat);
        } else {
            LOG.warn("SPOG-Unable to send heartbeat status update since channel is not ready yet .. {} ", (Object)super.getHost());
        }
    }

    private static class LoggingAckReceiver
    implements StreamObserver<Empty> {
        private final String type;
        private final SpogGrpcClient client;

        private LoggingAckReceiver(String type, SpogGrpcClient client) {
            this.type = Objects.requireNonNull(type);
            this.client = client;
        }

        public void onNext(Empty value) {
            LOG.debug("Received ACK {}", (Object)this.type);
        }

        public void onError(Throwable t) {
            LOG.error("Received error {}", (Object)this.type, (Object)t);
            this.client.reconnectStreams();
        }

        public void onCompleted() {
            LOG.info("Completed {}", (Object)this.type);
            this.client.reconnectStreams();
        }
    }
}

