/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceException;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceService;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcHeaderInterceptor
implements ClientInterceptor {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcHeaderInterceptor.class);
    private final Metadata metadata;
    private ZenithConnectPersistenceService zenithConnectPersistenceService;
    private final Metadata.Key authorizationKey = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Metadata.Key tenantIdKey = Metadata.Key.of((String)"tenant-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final boolean zenithConnectEnabled;

    public GrpcHeaderInterceptor(String tenantId, boolean zenithEnabled) {
        this.metadata = new Metadata();
        this.metadata.put(this.tenantIdKey, (Object)tenantId);
        this.zenithConnectEnabled = zenithEnabled;
    }

    public GrpcHeaderInterceptor(String tenantId) {
        this(tenantId, Boolean.FALSE);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (this.zenithConnectEnabled) {
            this.addAccessTokenInHeaders(this.metadata);
        }
        return new HeaderAttachingClientCall(next.newCall(method, callOptions), this.metadata);
    }

    public void setZenithConnectPersistenceService(ZenithConnectPersistenceService service) {
        this.zenithConnectPersistenceService = service;
    }

    private void addAccessTokenInHeaders(Metadata headers) {
        if (headers.containsKey(this.authorizationKey)) {
            headers.removeAll(this.authorizationKey);
        }
        if (this.zenithConnectPersistenceService != null) {
            try {
                ZenithConnectRegistration registrations = this.zenithConnectPersistenceService.getRegistrations().first();
                if (registrations != null) {
                    headers.put(this.authorizationKey, (Object)("Bearer " + registrations.accessToken));
                }
            }
            catch (ZenithConnectPersistenceException e) {
                LOG.warn("Error while fetching data from zenithConnectPersistenceService ", (Throwable)e);
            }
        }
    }

    private static final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Metadata metadata;

        HeaderAttachingClientCall(ClientCall<ReqT, RespT> call, Metadata metadataToAttach) {
            super(call);
            this.metadata = metadataToAttach;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            headers.merge(this.metadata);
            super.start(responseListener, headers);
        }
    }
}

