/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.DiscoveryBridgeTopology;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.scheduler.Schedulable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryBridgeDomains
extends Schedulable {
    public static final int DOMAIN_MATCH_MIN_SIZE = 20;
    public static final float DOMAIN_MATCH_MIN_RATIO = 0.5f;
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryBridgeDomains.class);
    private int m_maxthreads = 1;
    private final BridgeTopologyService m_bridgeTopologyService;

    public static DiscoveryBridgeDomains clone(DiscoveryBridgeDomains dbd) {
        return new DiscoveryBridgeDomains(dbd.getBridgeTopologyService());
    }

    public DiscoveryBridgeDomains(BridgeTopologyService bridgeTopologyService) {
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public static boolean checkMacSets(Set<String> setA, Set<String> setB) {
        HashSet<String> retainedSet = new HashSet<String>(setB);
        retainedSet.retainAll(setA);
        return retainedSet.size() > 20 || (float)retainedSet.size() > (float)setA.size() * 0.5f || (float)retainedSet.size() > (float)setB.size() * 0.5f;
    }

    private BroadcastDomain find(Set<Integer> nodes, Set<String> setA) throws BridgeTopologyException {
        BroadcastDomain domain = null;
        for (BroadcastDomain curBDomain : this.m_bridgeTopologyService.findAll()) {
            if (!DiscoveryBridgeDomains.checkMacSets(setA, curBDomain.getMacsOnSegments())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("find: node:{}, domain:{}", nodes, (Object)curBDomain.getBridgeNodesOnDomain());
            }
            if (domain != null) {
                throw new BridgeTopologyException("at least two domains found", (Topology)domain);
            }
            domain = curBDomain;
        }
        if (domain == null) {
            LOG.debug("find: nodes: [{}]. No domain found, creating new Domain", nodes);
            domain = new BroadcastDomain();
            this.m_bridgeTopologyService.add(domain);
        }
        for (Integer nodeid : nodes) {
            BroadcastDomain olddomain = this.m_bridgeTopologyService.getBroadcastDomain(nodeid.intValue());
            if (olddomain == null || domain == olddomain) continue;
            this.m_bridgeTopologyService.reconcile(olddomain, nodeid.intValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("find: node:[{}]. Removed from Old Domain \n{}", (Object)nodeid, (Object)olddomain.printTopology());
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSchedulable() {
        LOG.info("run: calculate topology on broadcast domains. Start");
        HashMap nodeondomainbft = new HashMap();
        HashMap<Object, Set> nodeBft = new HashMap<Object, Set>();
        HashMap nodeMacs = new HashMap();
        HashSet nodeids = new HashSet(this.m_bridgeTopologyService.getUpdateBftMap().keySet());
        LOG.debug("run: nodes with updated bft {}", nodeids);
        for (Object nodeid : nodeids) {
            Set links = this.m_bridgeTopologyService.useBridgeTopologyUpdateBFT(((Integer)nodeid).intValue());
            if (links == null || links.size() == 0) {
                LOG.warn("run: node:[{}]. no updated bft. Return", nodeid);
                continue;
            }
            nodeBft.put(nodeid, links);
            HashSet<String> macs = new HashSet<String>();
            for (BridgeForwardingTableEntry link : links) {
                macs.add(link.getMacAddress());
            }
            LOG.debug("run: node:[{}]. macs:{}", nodeid, macs);
            nodeMacs.put(nodeid, macs);
        }
        HashSet<Object> parsed = new HashSet<Object>();
        for (Object nodeidA : nodeBft.keySet()) {
            if (parsed.contains(nodeidA)) continue;
            nodeondomainbft.put(nodeidA, new HashMap());
            ((Map)nodeondomainbft.get(nodeidA)).put(nodeidA, (Set)nodeBft.get(nodeidA));
            parsed.add(nodeidA);
            for (Integer nodeidB : nodeBft.keySet()) {
                if (parsed.contains(nodeidB) || !DiscoveryBridgeDomains.checkMacSets((Set)nodeMacs.get(nodeidA), (Set)nodeMacs.get(nodeidB))) continue;
                ((Map)nodeondomainbft.get(nodeidA)).put(nodeidB, (Set)nodeBft.get(nodeidB));
                parsed.add(nodeidB);
            }
        }
        ArrayList<Callable<String>> taskList = new ArrayList<Callable<String>>();
        for (Integer nodeid : nodeondomainbft.keySet()) {
            LOG.debug("run: nodes are on same domain {}", ((Map)nodeondomainbft.get(nodeid)).keySet());
            try {
                BroadcastDomain domain = this.find(((Map)nodeondomainbft.get(nodeid)).keySet(), (Set)nodeMacs.get(nodeid));
                DiscoveryBridgeTopology nodebridgetopology = new DiscoveryBridgeTopology(domain);
                BroadcastDomain broadcastDomain = domain;
                synchronized (broadcastDomain) {
                    for (Integer bridgeId : ((Map)nodeondomainbft.get(nodeid)).keySet()) {
                        nodebridgetopology.addUpdatedBFT(bridgeId, (Set)((Map)nodeondomainbft.get(nodeid)).get(bridgeId));
                        this.m_bridgeTopologyService.updateBridgeOnDomain(domain, bridgeId);
                    }
                }
                Callable<String> task = () -> {
                    BroadcastDomain broadcastDomain = domain;
                    synchronized (broadcastDomain) {
                        Date now = new Date();
                        LOG.debug("run: calculate start");
                        nodebridgetopology.calculate();
                        LOG.debug("run: calculate end");
                        LOG.debug("run: save start");
                        this.m_bridgeTopologyService.store(domain, now);
                        LOG.debug("run: save end");
                    }
                    return "executed Task: " + nodebridgetopology.getInfo();
                };
                taskList.add(task);
                LOG.info("run: added Task {}", (Object)nodebridgetopology.getInfo());
            }
            catch (BridgeTopologyException e) {
                LOG.error("run: node: [{}], getting broadcast domain. Failed {}", (Object)nodeid, (Object)e.getMessage());
            }
        }
        int n = taskList.size();
        if (n > this.m_maxthreads) {
            n = this.m_maxthreads;
        }
        if (n > 0) {
            LOG.debug("run: creating executorService with {} Threads", (Object)n);
            ExecutorService executorService = Executors.newFixedThreadPool(n);
            LOG.debug("run: created executorService with {} Threads", (Object)n);
            try {
                for (Future future : executorService.invokeAll(taskList)) {
                    LOG.info("run: {}", future.get());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("run: executing task {}", (Object)e.getMessage(), (Object)e);
            }
            executorService.shutdown();
        } else {
            LOG.info("run: no updates on broadcast domains");
        }
        LOG.info("run: calculate topology on broadcast domains. End");
    }

    public String getName() {
        return "DiscoveryBridgeDomain";
    }

    public void setMaxthreads(int maxthreads) {
        this.m_maxthreads = maxthreads;
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }
}

