/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.MacCloud;
import org.opennms.netmgt.enlinkd.service.api.MacPort;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyShared;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeOnmsTopologyUpdater
extends TopologyUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeOnmsTopologyUpdater.class);
    private final BridgeTopologyService m_bridgeTopologyService;

    public static BridgeOnmsTopologyUpdater clone(BridgeOnmsTopologyUpdater bpu) {
        BridgeOnmsTopologyUpdater update = new BridgeOnmsTopologyUpdater(bpu.getTopologyDao(), bpu.getBridgeTopologyService(), bpu.getNodeTopologyService());
        update.setRunned(bpu.isRunned());
        update.setTopology(bpu.getTopology());
        return update;
    }

    public static OnmsTopologyVertex createSegmentVertex(TopologyShared segment) {
        OnmsTopologyVertex cloudVertex = OnmsTopologyVertex.create((String)Topology.getSharedSegmentId((TopologyShared)segment), (String)Topology.getSharedSegmentLabel(), null, (String)Topology.getCloudIconKey());
        cloudVertex.setToolTipText(Topology.getSharedSegmentTextString((TopologyShared)segment));
        return cloudVertex;
    }

    public static OnmsTopologyVertex createMacsCloudVertex(List<MacPort> ports, TopologyShared segment) {
        OnmsTopologyVertex vertex = OnmsTopologyVertex.create((String)Topology.getMacsCloudId((TopologyShared)segment), (String)Topology.getMacsIpLabel(), (String)Topology.getAddress((MacCloud)segment.getCloud(), ports), (String)Topology.getDefaultIconKey());
        vertex.setToolTipText(Topology.getMacsCloudIpTextString((TopologyShared)segment, ports));
        return vertex;
    }

    public static OnmsTopologyPort createVertexPort(OnmsTopologyVertex vertex) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)Topology.getPortId((String)vertex.getId()), (OnmsTopologyVertex)vertex, (Integer)-1);
        port.setToolTipText(vertex.getToolTipText());
        return port;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex source, BridgePort bp, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)Topology.getId((BridgePort)bp), (OnmsTopologyVertex)source, (Integer)bp.getBridgePort());
        port.setIfindex(bp.getBridgePortIfIndex());
        if (snmpiface != null) {
            port.setIfname(snmpiface.getIfName());
        }
        port.setAddr(Topology.getAddress((BridgePort)bp));
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)port.getIfindex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public static OnmsTopologyPort create(OnmsTopologyVertex source, MacPort mp, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)Topology.getId((MacPort)mp), (OnmsTopologyVertex)source, (Integer)mp.getIfIndex());
        port.setIfindex(mp.getIfIndex());
        if (snmpiface != null) {
            port.setIfname(snmpiface.getIfName());
        }
        port.setAddr(Topology.getAddress((MacPort)mp));
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)mp.getIfIndex(), (String)Topology.getAddress((MacPort)mp), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public BridgeOnmsTopologyUpdater(OnmsTopologyDao topologyDao, BridgeTopologyService bridgeTopologyService, NodeTopologyService nodeTopologyService) {
        super((TopologyService)bridgeTopologyService, topologyDao, nodeTopologyService);
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public String getName() {
        return "BridgeTopologyUpdaters";
    }

    public OnmsTopology buildTopology() {
        Map nodeMap = this.getNodeMap();
        Map ipMap = this.getIpPrimaryMap();
        Table snmpTable = this.getSnmpInterfaceTable();
        OnmsTopology topology = new OnmsTopology();
        for (TopologyShared shared : this.m_bridgeTopologyService.match()) {
            BridgePort sourcebp;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTopology: parsing shared designated: {}", (Object)shared.printTopology());
            }
            HashMap<BridgePort, OnmsTopologyVertex> bpVtxMap = new HashMap<BridgePort, OnmsTopologyVertex>();
            for (BridgePort bp : shared.getBridgePorts()) {
                NodeTopologyEntity node = (NodeTopologyEntity)nodeMap.get(bp.getNodeId());
                if (topology.getVertex(node.getId().toString()) == null) {
                    topology.getVertices().add(BridgeOnmsTopologyUpdater.create((NodeTopologyEntity)node, (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipMap.get(node.getId()))));
                }
                bpVtxMap.put(bp, topology.getVertex(node.getId().toString()));
            }
            HashMap<MacPort, OnmsTopologyVertex> macPortToNodeVertexMap = new HashMap<MacPort, OnmsTopologyVertex>();
            ArrayList<MacPort> portsWithoutNode = new ArrayList<MacPort>();
            for (MacPort mp : shared.getMacPorts()) {
                if (mp.getNodeId() == null) {
                    portsWithoutNode.add(mp);
                    continue;
                }
                NodeTopologyEntity node = (NodeTopologyEntity)nodeMap.get(mp.getNodeId());
                if (topology.getVertex(node.getId().toString()) == null) {
                    topology.getVertices().add(BridgeOnmsTopologyUpdater.create((NodeTopologyEntity)node, (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipMap.get(node.getId()))));
                }
                macPortToNodeVertexMap.put(mp, topology.getVertex(node.getId().toString()));
            }
            OnmsTopologyVertex macsVertex = null;
            OnmsTopologyPort macsVertexPort = null;
            if (shared.getCloud() != null || portsWithoutNode.size() > 0) {
                macsVertex = BridgeOnmsTopologyUpdater.createMacsCloudVertex(portsWithoutNode, shared);
                topology.getVertices().add(macsVertex);
                macsVertexPort = BridgeOnmsTopologyUpdater.createVertexPort(macsVertex);
            }
            if (bpVtxMap.size() == 2 && macPortToNodeVertexMap.size() == 0 && macsVertex == null) {
                sourcebp = null;
                BridgePort targetbp = null;
                OnmsTopologyPort sourceport = null;
                OnmsTopologyPort targetport = null;
                for (BridgePort bp : bpVtxMap.keySet()) {
                    SnmpInterfaceTopologyEntity snmpiface = (SnmpInterfaceTopologyEntity)snmpTable.get((Object)bp.getNodeId(), (Object)bp.getBridgePortIfIndex());
                    if (bp.getNodeId().intValue() == shared.getUpPort().getNodeId().intValue()) {
                        sourcebp = bp;
                        sourceport = BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)bpVtxMap.get(bp), bp, snmpiface);
                        continue;
                    }
                    targetbp = bp;
                    targetport = BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)bpVtxMap.get(bp), bp, snmpiface);
                }
                assert (sourcebp != null);
                assert (targetbp != null);
                topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getEdgeId((BridgePort)sourcebp, targetbp), sourceport, targetport));
                continue;
            }
            if (bpVtxMap.size() == 1 && macPortToNodeVertexMap.size() == 1 && macsVertex == null) {
                sourcebp = (BridgePort)bpVtxMap.keySet().iterator().next();
                MacPort targetmp = (MacPort)macPortToNodeVertexMap.keySet().iterator().next();
                topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getEdgeId((BridgePort)sourcebp, (MacPort)targetmp), (OnmsTopologyPort)BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)bpVtxMap.get(sourcebp), sourcebp, (SnmpInterfaceTopologyEntity)snmpTable.get((Object)sourcebp.getNodeId(), (Object)sourcebp.getBridgePortIfIndex())), (OnmsTopologyPort)BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)macPortToNodeVertexMap.get(targetmp), targetmp, (SnmpInterfaceTopologyEntity)snmpTable.get((Object)targetmp.getNodeId(), (Object)targetmp.getIfIndex()))));
                continue;
            }
            if (bpVtxMap.size() == 1 && macPortToNodeVertexMap.size() == 0 && macsVertex != null) {
                sourcebp = (BridgePort)bpVtxMap.keySet().iterator().next();
                topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getEdgeId((String)macsVertex.getId(), (BridgePort)sourcebp), (OnmsTopologyPort)BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)bpVtxMap.values().iterator().next(), sourcebp, (SnmpInterfaceTopologyEntity)snmpTable.get((Object)sourcebp.getNodeId(), (Object)sourcebp.getBridgePortIfIndex())), (OnmsTopologyPort)macsVertexPort));
                continue;
            }
            OnmsTopologyVertex segment = BridgeOnmsTopologyUpdater.createSegmentVertex(shared);
            OnmsTopologyPort segmentPort = BridgeOnmsTopologyUpdater.createVertexPort(segment);
            topology.getVertices().add(segment);
            for (BridgePort bp : bpVtxMap.keySet()) {
                topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getEdgeId((String)segment.getId(), (BridgePort)bp), (OnmsTopologyPort)segmentPort, (OnmsTopologyPort)BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)bpVtxMap.get(bp), bp, (SnmpInterfaceTopologyEntity)snmpTable.get((Object)bp.getNodeId(), (Object)bp.getBridgePortIfIndex()))));
            }
            for (MacPort mp : macPortToNodeVertexMap.keySet()) {
                topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getEdgeId((String)segment.getId(), (MacPort)mp), (OnmsTopologyPort)segmentPort, (OnmsTopologyPort)BridgeOnmsTopologyUpdater.create((OnmsTopologyVertex)macPortToNodeVertexMap.get(mp), mp, (SnmpInterfaceTopologyEntity)snmpTable.get((Object)mp.getNodeId(), (Object)mp.getIfIndex()))));
            }
            if (macsVertex == null) continue;
            topology.getEdges().add(OnmsTopologyEdge.create((String)Topology.getDefaultEdgeId((String)segment.getId(), (String)macsVertex.getId()), (OnmsTopologyPort)segmentPort, (OnmsTopologyPort)macsVertexPort));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return BridgeOnmsTopologyUpdater.create((ProtocolSupported)ProtocolSupported.BRIDGE);
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }
}

