/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.measurements.api.FilterParam;

@XmlRootElement(name="parameter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterParamMetaData {
    @XmlAttribute(name="key", required=true)
    private String key;
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlAttribute(name="displayName", required=true)
    private String displayName;
    @XmlAttribute(name="description", required=true)
    private String description;
    @XmlAttribute(name="default")
    private String defaultValue;
    @XmlAttribute(name="required", required=true)
    private boolean required = false;

    public FilterParamMetaData() {
    }

    public FilterParamMetaData(Field field, FilterParam filterParam) {
        Preconditions.checkNotNull(field, "field argument");
        Preconditions.checkNotNull(filterParam, "filterParam argument");
        this.key = filterParam.key();
        this.type = field.getType().getSimpleName().toLowerCase();
        this.displayName = filterParam.displayName();
        this.description = filterParam.description();
        this.defaultValue = filterParam.value();
        this.required = filterParam.required();
        if (this.required) {
            this.defaultValue = null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterParamMetaData other = (FilterParamMetaData)obj;
        return Objects.equal(this.key, other.key) && Objects.equal(this.type, other.type) && Objects.equal(this.displayName, other.displayName) && Objects.equal(this.description, other.description) && Objects.equal(this.defaultValue, other.defaultValue) && Objects.equal(this.required, other.required);
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.type, this.displayName, this.description, this.defaultValue, this.required);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Key", this.key).add("Type", this.type).add("Display Name", this.displayName).add("Description", this.description).add("Default", this.defaultValue).add("Required", this.required).toString();
    }
}

