/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.lookup;

import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingServiceLookup<C, F>
implements ServiceLookup<C, F> {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingServiceLookup.class);
    private final ServiceLookup<C, F> delegate;
    private long gracePeriodInMs;
    private Supplier<Long> uptimeSupplier;
    private long lookupDelayMs;
    private long waitTimeMs;

    protected BlockingServiceLookup(ServiceLookup<C, F> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public <T> T lookup(C criteria, F filter) {
        Objects.requireNonNull(criteria);
        Object service = this.delegate.lookup(criteria, filter);
        if (service != null) {
            return service;
        }
        long waitUntil = System.currentTimeMillis() + this.waitTimeMs;
        while (this.uptimeSupplier.get() < this.gracePeriodInMs || System.currentTimeMillis() < waitUntil) {
            try {
                Thread.sleep(this.lookupDelayMs);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for service with search criteria '{}' to become available in the service registry. Aborting.", (Object)criteria);
                return null;
            }
            service = this.delegate.lookup(criteria, filter);
            if (service == null) continue;
            return service;
        }
        LOG.error("Timed out while waiting for service with search criteria '{}' to become available in the service registry. Aborting.", (Object)criteria);
        return null;
    }

    void setGracePeriodInMs(long gracePeriodInMs) {
        this.gracePeriodInMs = gracePeriodInMs;
    }

    void setUptimeSupplier(Supplier<Long> uptimeSupplier) {
        this.uptimeSupplier = uptimeSupplier;
    }

    void setLookupDelayMs(long lookupDelayMs) {
        this.lookupDelayMs = lookupDelayMs;
    }

    public void setWaitTimeMs(long waitTimeMs) {
        this.waitTimeMs = waitTimeMs;
    }
}

