/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.codehaus.jackson.map.ObjectMapper;
import org.opennms.core.config.api.ConfigReloadContainer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JacksonUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.FileSystemSaveableConfigContainer;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThresholdingDao;
import org.opennms.netmgt.config.dao.thresholding.impl.AbstractThresholdingDao;
import org.opennms.netmgt.config.threshd.ThresholdingConfig;

public class OnmsThresholdingDao
extends AbstractThresholdingDao
implements WriteableThresholdingDao {
    private final SaveableConfigContainer<ThresholdingConfig> saveableConfigContainer;
    private final ConfigReloadContainer<ThresholdingConfig> extContainer;
    private final ObjectMapper objectMapper = JacksonUtils.createDefaultObjectMapper();
    private volatile ThresholdingConfig filesystemConfig;

    @VisibleForTesting
    OnmsThresholdingDao(JsonStore jsonStore, File configFile) {
        super(jsonStore);
        Objects.requireNonNull(configFile);
        this.extContainer = new ConfigReloadContainer.Builder(ThresholdingConfig.class).withFolder((accumulator, next) -> accumulator.getGroups().addAll(next.getGroups())).build();
        this.saveableConfigContainer = new FileSystemSaveableConfigContainer(ThresholdingConfig.class, "thresholds", Collections.singleton(this::fileSystemConfigUpdated), configFile);
        this.reload();
    }

    public OnmsThresholdingDao(JsonStore jsonStore) throws IOException {
        this(jsonStore, ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHOLDING_CONF_FILE_NAME));
    }

    public void saveConfig() {
        this.saveableConfigContainer.saveConfig();
    }

    public ThresholdingConfig getReadOnlyConfig() {
        return this.getMergedConfig();
    }

    public ThresholdingConfig getWriteableConfig() {
        return (ThresholdingConfig)this.saveableConfigContainer.getConfig();
    }

    private synchronized ThresholdingConfig getMergedConfig() {
        ThresholdingConfig externalConfig = (ThresholdingConfig)this.extContainer.getObject();
        if (this.filesystemConfig == null && externalConfig == null) {
            return null;
        }
        if (externalConfig == null) {
            return this.filesystemConfig;
        }
        if (this.filesystemConfig == null) {
            return externalConfig;
        }
        ThresholdingConfig mergedConfig = new ThresholdingConfig();
        ArrayList groups = new ArrayList();
        groups.addAll(this.filesystemConfig.getGroups());
        groups.addAll(externalConfig.getGroups());
        mergedConfig.setGroups(Collections.unmodifiableList(groups));
        return mergedConfig;
    }

    private synchronized void publishMergedConfig() {
        try {
            this.jsonStore.put("thresholds", (Object)this.objectMapper.writeValueAsString((Object)this.getMergedConfig()), "config");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        this.saveableConfigContainer.reload();
    }

    public void onConfigChanged() {
        this.publishMergedConfig();
    }

    private synchronized void fileSystemConfigUpdated(ThresholdingConfig updatedConfig) {
        this.filesystemConfig = updatedConfig;
        this.onConfigChanged();
    }
}

