/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opennms.osgi.EventConsumer;
import org.opennms.osgi.EventListener;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.EventProxyImpl;
import org.opennms.osgi.OnmsServiceManager;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.locator.OnmsServiceManagerLocator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRegistry {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;

    public EventRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void addPossibleEventConsumer(Object possibleEventConsumer, VaadinApplicationContext applicationContext) {
        if (possibleEventConsumer == null) {
            return;
        }
        if (this.isPossibleEventConsumer(possibleEventConsumer)) {
            List<Method> eventConsumerMethods = this.getEventConsumerMethods(possibleEventConsumer.getClass());
            for (Method eachEventConsumerMethod : eventConsumerMethods) {
                boolean hasMultipleTypes;
                boolean hasType = eachEventConsumerMethod.getParameterTypes() != null && eachEventConsumerMethod.getParameterTypes().length > 0;
                boolean bl = hasMultipleTypes = eachEventConsumerMethod.getParameterTypes() != null && eachEventConsumerMethod.getParameterTypes().length > 1;
                if (!hasType) {
                    this.LOG.warn("The method '{1}' in class '{2}' is annotated as a 'EventConsumer' but does not have any event type as a parameter. Method is ignored", (Object)eachEventConsumerMethod.getName(), possibleEventConsumer.getClass());
                    continue;
                }
                if (hasMultipleTypes) {
                    this.LOG.warn("The method '{1}' in class '{2}' has multiple parameters. It must only have one parameter. Method is ignored", (Object)eachEventConsumerMethod.getName(), possibleEventConsumer.getClass());
                    continue;
                }
                EventListener listener = new EventListener();
                listener.setEventConsumer(possibleEventConsumer);
                listener.setEventMethod(eachEventConsumerMethod);
                this.getOnmsServiceManager().registerAsService(EventListener.class, listener, applicationContext, EventListener.getProperties(eachEventConsumerMethod.getParameterTypes()[0]));
            }
        }
    }

    public EventProxy getScope(VaadinApplicationContext vaadinApplicationContext) {
        return new EventProxyImpl(this.bundleContext, vaadinApplicationContext);
    }

    private OnmsServiceManager getOnmsServiceManager() {
        return new OnmsServiceManagerLocator().lookup(this.bundleContext);
    }

    private boolean isPossibleEventConsumer(Object possibleEventConsumer) {
        if (possibleEventConsumer == null) {
            return false;
        }
        return !this.getEventConsumerMethods(possibleEventConsumer.getClass()).isEmpty();
    }

    private List<Method> getEventConsumerMethods(Class<?> clazz) {
        ArrayList<Method> eventConsumerMethods = new ArrayList<Method>();
        for (Method eachMethod : clazz.getMethods()) {
            if (eachMethod.getAnnotation(EventConsumer.class) == null) continue;
            eventConsumerMethods.add(eachMethod);
        }
        return eventConsumerMethods;
    }
}

