/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.model.OnmsSeverity;

public class StatusSummary {
    private final Map<OnmsSeverity, Long> severityMap;

    public StatusSummary(List<OnmsSeverity> severityList, long totalCount) {
        this.severityMap = severityList.stream().collect(Collectors.groupingBy(severity -> severity, Collectors.counting()));
        StatusSummary.updateNormalSeverity(this.severityMap, totalCount);
        StatusSummary.enrich(this.severityMap);
    }

    public StatusSummary(Map<OnmsSeverity, Long> severityMap, long totalCount) {
        this.severityMap = Objects.requireNonNull(severityMap);
        StatusSummary.updateNormalSeverity(severityMap, totalCount);
        StatusSummary.enrich(severityMap);
    }

    public Map<OnmsSeverity, Long> getSeverityMap() {
        return this.severityMap;
    }

    private static void updateNormalSeverity(Map<OnmsSeverity, Long> severityMap, long totalCount) {
        long severityCount = severityMap.values().stream().mapToLong(count -> count).sum();
        long normalCount = totalCount - severityCount + severityMap.getOrDefault(OnmsSeverity.NORMAL, 0L);
        severityMap.put(OnmsSeverity.NORMAL, normalCount);
    }

    private static void enrich(Map<OnmsSeverity, Long> severityMap) {
        severityMap.putIfAbsent(OnmsSeverity.NORMAL, 0L);
        severityMap.putIfAbsent(OnmsSeverity.WARNING, 0L);
        severityMap.putIfAbsent(OnmsSeverity.MINOR, 0L);
        severityMap.putIfAbsent(OnmsSeverity.MAJOR, 0L);
        severityMap.putIfAbsent(OnmsSeverity.CRITICAL, 0L);
    }
}

