/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.setsequence;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.opennms.setsequence.SetSequenceStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="setSequence", description="Set Sequence", priority=1)
public class SetSequenceChange
extends AbstractChange {
    private String m_schemaName;
    private String m_tableName;
    private String m_column;
    private String m_sequenceName;
    private Integer m_value;

    public void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setColumn(String column) {
        this.m_column = column;
    }

    public String getColumn() {
        return this.m_column;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void setValue(String value) {
        this.m_value = value == null ? null : Integer.valueOf(value);
    }

    public String getValue() {
        return this.m_value == null ? null : this.m_value.toString();
    }

    public SqlStatement[] generateStatements(Database database) {
        SetSequenceStatement statement = new SetSequenceStatement(this.getSequenceName());
        statement.setValue(this.m_value);
        statement.addTable(this.m_tableName, this.m_schemaName, this.m_column);
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Sequence " + this.m_sequenceName + " updated";
    }
}

