/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.google.common.base.Strings;
import java.util.Map;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteria;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteriaBuilder;
import org.opennms.netmgt.bsm.service.model.Status;

public class BSMConfigHelper {
    public static boolean getBooleanForKey(Map<String, String> map, String key) {
        String value = map.get(key);
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    public static String getStringForKey(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        if (Strings.isNullOrEmpty((String)value)) {
            value = defaultValue;
        }
        return value;
    }

    public static int getIntForKey(Map<String, String> map, String key, int defaultValue) {
        String value = map.get(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static BusinessServiceSearchCriteria fromMap(Map<String, String> map) {
        boolean filterByName = BSMConfigHelper.getBooleanForKey(map, "filterByName");
        String nameValue = BSMConfigHelper.getStringForKey(map, "nameValue", "");
        boolean filterByAttribute = BSMConfigHelper.getBooleanForKey(map, "filterByAttribute");
        String attributeKey = BSMConfigHelper.getStringForKey(map, "attributeKey", "");
        String attributeValue = BSMConfigHelper.getStringForKey(map, "attributeValue", "");
        boolean filterBySeverity = BSMConfigHelper.getBooleanForKey(map, "filterBySeverity");
        String severityValue = BSMConfigHelper.getStringForKey(map, "severityValue", Status.WARNING.getLabel());
        String severityCompareOperator = BSMConfigHelper.getStringForKey(map, "severityCompareOperator", BusinessServiceSearchCriteriaBuilder.CompareOperator.GreaterOrEqual.name());
        String orderBy = BSMConfigHelper.getStringForKey(map, "orderBy", BusinessServiceSearchCriteriaBuilder.Order.Name.name());
        String orderSequence = BSMConfigHelper.getStringForKey(map, "orderSequence", BusinessServiceSearchCriteriaBuilder.Sequence.Ascending.name());
        int resultsLimit = BSMConfigHelper.getIntForKey(map, "resultsLimit", 10);
        BusinessServiceSearchCriteriaBuilder b = new BusinessServiceSearchCriteriaBuilder();
        if (filterByName) {
            b.name(nameValue);
        }
        if (filterByAttribute) {
            b.attribute(attributeKey, attributeValue);
        }
        if (filterBySeverity) {
            b.filterSeverity(BusinessServiceSearchCriteriaBuilder.CompareOperator.valueOf((String)severityCompareOperator), Status.valueOf((String)severityValue));
        }
        return b.order(BusinessServiceSearchCriteriaBuilder.Order.valueOf((String)orderBy)).order(BusinessServiceSearchCriteriaBuilder.Sequence.valueOf((String)orderSequence)).limit(resultsLimit);
    }
}

