/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api.model;

import java.util.Objects;
import org.opennms.netmgt.events.api.model.ILogMsg;

public final class ImmutableLogMsg
implements ILogMsg {
    private final String content;
    private final Boolean notify;
    private final String dest;

    private ImmutableLogMsg(Builder builder) {
        this.content = builder.content;
        this.notify = builder.notify;
        this.dest = builder.dest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(ILogMsg logMsg) {
        return new Builder(logMsg);
    }

    public static ILogMsg immutableCopy(ILogMsg logMsg) {
        if (logMsg == null || logMsg instanceof ImmutableLogMsg) {
            return logMsg;
        }
        return ImmutableLogMsg.newBuilderFrom(logMsg).build();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Boolean getNotify() {
        return this.notify == null ? false : this.notify;
    }

    @Override
    public boolean hasNotify() {
        return this.notify != null;
    }

    @Override
    public String getDest() {
        return this.dest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLogMsg that = (ImmutableLogMsg)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.notify, that.notify) && Objects.equals(this.dest, that.dest);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.notify, this.dest);
    }

    public String toString() {
        return "ImmutableLogMsg{content='" + this.content + "', notify=" + this.notify + ", dest='" + this.dest + "'}";
    }

    public static final class Builder {
        private String content;
        private Boolean notify;
        private String dest;

        private Builder() {
        }

        public Builder(ILogMsg logMsg) {
            this.content = logMsg.getContent();
            this.notify = logMsg.getNotify();
            this.dest = logMsg.getDest();
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setNotify(Boolean notify) {
            this.notify = notify;
            return this;
        }

        public Builder setDest(String dest) {
            this.dest = dest;
            return this;
        }

        public ImmutableLogMsg build() {
            return new ImmutableLogMsg(this);
        }
    }
}

