/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.db.install.Column;
import org.opennms.core.db.install.Constraint;

public class Table {
    private String m_name;
    private List<Column> m_columns;
    private List<Constraint> m_constraints;

    public List<Column> getColumns() {
        return this.m_columns;
    }

    public void setColumns(List<Column> columns) {
        this.m_columns = columns;
    }

    public List<Constraint> getConstraints() {
        return this.m_constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.m_constraints = constraints;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.toLowerCase();
    }

    public void setNotNullOnPrimaryKeyColumns() throws Exception {
        for (Constraint constraint : this.getConstraints()) {
            if (!constraint.isPrimaryKeyConstraint()) continue;
            for (String constrainedColumn : constraint.getColumns()) {
                boolean foundColumn = false;
                for (Column column : this.getColumns()) {
                    if (!constrainedColumn.equals(column.getName())) continue;
                    column.setNotNull(true);
                    foundColumn = true;
                    break;
                }
                if (foundColumn) continue;
                throw new Exception("could not find column '" + constrainedColumn + "' for constraint: " + String.valueOf(constraint));
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        return new EqualsBuilder().append(this.getColumns(), other.getColumns()).append(this.getConstraints(), other.getConstraints()).append((Object)this.getName(), (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 73).append((Object)this.m_name).append(this.m_columns).append(this.m_constraints).toHashCode();
    }
}

