/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collection;
import java.util.HashSet;
import org.opennms.netmgt.model.OnmsUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SpringSecurityUser
implements UserDetails {
    private static final long serialVersionUID = 7736070473646649732L;
    private final OnmsUser m_user;
    private Collection<? extends GrantedAuthority> m_authorities;

    public SpringSecurityUser(OnmsUser user) {
        this.m_user = user;
    }

    public String getUsername() {
        return this.m_user.getUsername();
    }

    public String getPassword() {
        return this.m_user.getPassword();
    }

    public String getFullName() {
        return this.m_user.getFullName();
    }

    public String getComments() {
        return this.m_user.getComments();
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.m_authorities = authorities;
    }

    public void addAuthority(GrantedAuthority authority) {
        HashSet<? extends GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (this.m_authorities != null) {
            authorities.addAll(this.m_authorities);
        }
        authorities.add(authority);
        this.m_authorities = authorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.m_authorities;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_authorities == null ? 0 : this.m_authorities.hashCode());
        result = 31 * result + (this.m_user == null ? 0 : this.m_user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpringSecurityUser other = (SpringSecurityUser)obj;
        if (this.m_authorities == null ? other.m_authorities != null : !this.m_authorities.equals(other.m_authorities)) {
            return false;
        }
        return !(this.m_user == null ? other.m_user != null : !this.m_user.equals((Object)other.m_user));
    }
}

