/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.dhcpd.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.dhcp4java.DHCPOption;
import org.dhcp4java.DHCPPacket;
import org.opennms.features.dhcpd.Dhcpd;
import org.opennms.features.dhcpd.Transaction;
import org.opennms.features.dhcpd.impl.Listener;
import org.opennms.features.dhcpd.impl.Response;
import org.opennms.features.dhcpd.impl.TransactionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpdImpl
implements Dhcpd {
    private static final Logger LOG = LoggerFactory.getLogger(DhcpdImpl.class);
    private final Set<TransactionImpl> transactions = new HashSet<TransactionImpl>();
    private int xid = new Random().nextInt();
    private boolean shutdown = false;
    private final Listener port67Listener = new Listener(this, 67);
    private final Listener port68Listener = new Listener(this, 68);

    private synchronized int nextXid() {
        return this.xid++;
    }

    private DHCPPacket createPacket(int xid, TransactionImpl transaction, byte messageType) {
        DHCPPacket dhcpPacket = new DHCPPacket();
        dhcpPacket.setOp((byte)1);
        dhcpPacket.setDHCPMessageType(messageType);
        dhcpPacket.setHtype((byte)1);
        dhcpPacket.setHlen((byte)6);
        dhcpPacket.setChaddr(transaction.getMacAddress());
        dhcpPacket.setXid(xid);
        dhcpPacket.setSecs((short)0);
        if (transaction.isRelayMode()) {
            dhcpPacket.setGiaddr(transaction.getMyIpAddress());
            dhcpPacket.setHops((byte)1);
        } else {
            dhcpPacket.setHops((byte)0);
            dhcpPacket.setFlags((short)Short.MIN_VALUE);
        }
        switch (dhcpPacket.getDHCPMessageType()) {
            case 3: {
                dhcpPacket.setOption(DHCPOption.newOptionAsInetAddress((byte)50, (InetAddress)transaction.getRequestIpAddress()));
                dhcpPacket.setCiaddr(transaction.getRequestIpAddress());
                break;
            }
            case 8: {
                dhcpPacket.setOption(DHCPOption.newOptionAsInetAddress((byte)50, (InetAddress)transaction.getMyIpAddress()));
                dhcpPacket.setCiaddr(transaction.getMyIpAddress());
            }
        }
        return dhcpPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndWait(TransactionImpl transaction) throws IOException {
        if (this.shutdown || !this.port67Listener.start() || !this.port68Listener.start()) {
            return;
        }
        int xid = this.nextXid();
        transaction.setXid(xid);
        Set<TransactionImpl> set = this.transactions;
        synchronized (set) {
            this.transactions.add(transaction);
        }
        ArrayList<DHCPPacket> dhcpPackets = new ArrayList<DHCPPacket>();
        dhcpPackets.add(this.createPacket(xid, transaction, (byte)1));
        if (transaction.isExtendedMode()) {
            dhcpPackets.add(this.createPacket(xid, transaction, (byte)8));
            dhcpPackets.add(this.createPacket(xid, transaction, (byte)3));
        }
        for (DHCPPacket dhcpPacket : dhcpPackets) {
            byte[] buf = dhcpPacket.serialize();
            DatagramPacket discoverPacket = new DatagramPacket(buf, buf.length);
            discoverPacket.setAddress(transaction.getHostAddress());
            transaction.updateStartTime();
            if (transaction.isRelayMode()) {
                discoverPacket.setPort(67);
                this.port67Listener.send(discoverPacket);
            } else {
                discoverPacket.setPort(67);
                this.port68Listener.send(discoverPacket);
            }
            for (int i = 0; i < Math.max(0, transaction.getTimeout() / 250); ++i) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!transaction.isSuccess()) continue;
                Set<TransactionImpl> set2 = this.transactions;
                synchronized (set2) {
                    this.transactions.remove(transaction);
                }
                return;
            }
        }
        Set<TransactionImpl> set3 = this.transactions;
        synchronized (set3) {
            this.transactions.remove(transaction);
        }
    }

    @Override
    public Transaction executeTransaction(String hostAddress, String macAddress, boolean relayMode, String myIpAddress, boolean extendedMode, String requestIpAddress, int timeout) throws IOException {
        TransactionImpl transaction = new TransactionImpl(hostAddress, macAddress, relayMode, myIpAddress, extendedMode, requestIpAddress, timeout);
        this.executeAndWait(transaction);
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTransactions(Response response) {
        Set<TransactionImpl> set = this.transactions;
        synchronized (set) {
            if (this.transactions.isEmpty()) {
                LOG.debug("No polling request is waiting for response.");
                return;
            }
            for (TransactionImpl transaction : this.transactions) {
                if (!transaction.check(response)) continue;
                return;
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.port67Listener.stop();
        this.port68Listener.stop();
        LOG.debug("Dhcpd terminated successfully.");
    }
}

