/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.model.BridgeMacLink;
import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.util.Assert;

public class BridgePortWithMacs
implements Topology {
    private final BridgePort m_port;
    private final Set<String> m_macs;

    public BridgePortWithMacs(BridgePort port, Set<String> macs) {
        Assert.notNull((Object)port);
        Assert.notNull(macs);
        this.m_port = port;
        this.m_macs = macs;
    }

    public BridgePort getPort() {
        return this.m_port;
    }

    public Set<String> getMacs() {
        return this.m_macs;
    }

    public List<BridgeMacLink> getBridgeMacLinks() {
        ArrayList<BridgeMacLink> links = new ArrayList<BridgeMacLink>();
        this.m_macs.forEach(mac -> {
            BridgeMacLink maclink = new BridgeMacLink();
            OnmsNode node = new OnmsNode();
            node.setId(this.m_port.getNodeId());
            maclink.setNode(node);
            maclink.setBridgePort(this.m_port.getBridgePort());
            maclink.setBridgePortIfIndex(this.m_port.getBridgePortIfIndex());
            maclink.setMacAddress(mac);
            maclink.setVlan(this.m_port.getVlan());
            maclink.setLinkType(BridgeMacLink.BridgeMacLinkType.BRIDGE_FORWARDER);
            links.add(maclink);
        });
        return links;
    }

    public Set<BridgeForwardingTableEntry> getBridgeForwardingTableEntrySet() {
        HashSet<BridgeForwardingTableEntry> bftentries = new HashSet<BridgeForwardingTableEntry>();
        this.m_macs.forEach(mac -> {
            BridgeForwardingTableEntry bftentry = new BridgeForwardingTableEntry();
            bftentry.setNodeId(this.m_port.getNodeId());
            bftentry.setBridgePort(this.m_port.getBridgePort());
            bftentry.setBridgePortIfIndex(this.m_port.getBridgePortIfIndex());
            bftentry.setVlan(this.m_port.getVlan());
            bftentry.setMacAddress((String)mac);
            bftentry.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
            bftentries.add(bftentry);
        });
        return bftentries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BridgePortWithMacs that = (BridgePortWithMacs)o;
        return Objects.equals(this.m_port, that.m_port);
    }

    public int hashCode() {
        return Objects.hash(this.m_port);
    }

    @Override
    public String printTopology() {
        return this.m_port.printTopology() + " macs:" + String.valueOf(this.m_macs);
    }
}

