/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.telemetry.config.api.ParserDefinition;
import org.opennms.netmgt.telemetry.config.model.ListenerConfig;
import org.opennms.netmgt.telemetry.config.model.Parameter;
import org.opennms.netmgt.telemetry.config.model.QueueConfig;

@XmlRootElement(name="parser")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ParserConfig
implements ParserDefinition {
    @XmlTransient
    private ListenerConfig listener;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlAttribute(name="queue", required=true)
    @XmlIDREF
    private QueueConfig queue;
    @XmlElement(name="parameter")
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public ListenerConfig getListener() {
        return this.listener;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public QueueConfig getQueue() {
        return this.queue;
    }

    public void setQueue(QueueConfig queue) {
        this.queue = queue;
    }

    @XmlTransient
    public String getQueueName() {
        if (this.queue != null) {
            return this.queue.getName();
        }
        return null;
    }

    @XmlTransient
    public String getFullName() {
        return String.format("%s.%s", this.listener.getName(), this.getName());
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters.stream().collect(Collectors.toMap(Parameter::getKey, Parameter::getValue));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParserConfig that = (ParserConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.queue, that.queue) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.queue, this.parameters);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("class-name", (Object)this.className).add("queue", (Object)this.queue.getName()).add("parameters", this.parameters).toString();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.listener = (ListenerConfig)parent;
    }
}

