/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.rrd.model.AbstractRRD;
import org.opennms.netmgt.rrd.model.v1.RRDv1;
import org.opennms.netmgt.rrd.model.v3.RRDv3;
import org.opennms.netmgt.rrd.util.RrdConvertUtils;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.opennms.upgrade.implementations.SnmpInterfaceUpgrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SnmpInterfaceRrdMigratorOnline
extends AbstractOnmsUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpInterfaceRrdMigratorOnline.class);
    private List<SnmpInterfaceUpgrade> interfacesToMerge;

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "Merge SNMP Interface directories (Online Version): NMS-6056";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return true;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.printMainSettings();
        if (this.getRrdExtension() == null) {
            throw new OnmsUpgradeException("Can't find the configured extension for JRB/RRD.");
        }
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DATA_COLLECTION_CONF_FILE_NAME);
            DefaultDataCollectionConfigDao config = new DefaultDataCollectionConfigDao();
            config.setConfigResource((Resource)new FileSystemResource(cfgFile));
            config.afterPropertiesSet();
            config.getConfiguredResourceTypes();
            DataCollectionConfigFactory.setInstance((DataCollectionConfigDao)config);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't initialize datacollection-config.xml because " + e.getMessage());
        }
        this.interfacesToMerge = this.getInterfacesToMerge();
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        for (SnmpInterfaceUpgrade intf : this.interfacesToMerge) {
            try {
                this.createBackup(intf);
                this.merge(intf.getOldInterfaceDir(), intf.getNewInterfaceDir());
                this.removeBackup(intf);
            }
            catch (Exception e) {
                StringWriter w = new StringWriter();
                PrintWriter p = new PrintWriter(w);
                e.printStackTrace(p);
                this.log("Error: Can't upgrade %s because %s: %s. Rolling back changes\n", intf, e.getMessage(), w.toString());
                this.restoreBackup(intf);
            }
        }
    }

    private void createBackup(SnmpInterfaceUpgrade intf) throws OnmsUpgradeException {
        File[] targets;
        for (File target : targets = new File[]{intf.getOldInterfaceDir(), intf.getNewInterfaceDir()}) {
            if (!target.exists()) continue;
            this.log("Backing up: %s\n", target);
            this.zipDir(new File(target.getAbsolutePath() + ".zip"), target);
        }
    }

    private void restoreBackup(SnmpInterfaceUpgrade intf) throws OnmsUpgradeException {
        File[] targets;
        for (File target : targets = new File[]{intf.getOldInterfaceDir(), intf.getNewInterfaceDir()}) {
            File zip = new File(target.getAbsolutePath() + ".zip");
            try {
                FileUtils.deleteDirectory((File)target);
            }
            catch (IOException e1) {
                this.log("Warning: can't delete directory %s\n", target);
            }
            if (!target.mkdirs()) {
                LOG.warn("Could not make directory: {}", (Object)target.getPath());
            }
            if (!zip.exists()) continue;
            this.unzipFile(zip, target);
            if (zip.delete()) continue;
            LOG.warn("Could not delete file: {}", (Object)zip.getPath());
        }
    }

    private void removeBackup(SnmpInterfaceUpgrade intf) {
        File[] targets;
        for (File target : targets = new File[]{intf.getOldInterfaceDir(), intf.getNewInterfaceDir()}) {
            File zip = new File(target.getAbsolutePath() + ".zip");
            if (!zip.exists()) continue;
            this.log("Removing backup: %s\n", zip);
            if (zip.delete()) continue;
            LOG.warn("Could not delete file: {}", (Object)zip.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SnmpInterfaceUpgrade> getInterfacesToMerge() throws OnmsUpgradeException {
        ArrayList<SnmpInterfaceUpgrade> interfacesToMerge = new ArrayList<SnmpInterfaceUpgrade>();
        Connection conn = this.getDbConnection();
        DBUtils db = new DBUtils(this.getClass());
        db.watch((Object)conn);
        try {
            Statement st = conn.createStatement();
            db.watch((Object)st);
            String query = "SELECT n.nodeid, n.foreignsource, n.foreignid, i.snmpifdescr, i.snmpifname, i.snmpphysaddr from node n, snmpinterface i where n.nodeid = i.nodeid and i.snmpphysaddr is not null order by n.nodeid, i.snmpifdescr";
            ResultSet rs = st.executeQuery(query);
            db.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                ++count;
                SnmpInterfaceUpgrade intf = new SnmpInterfaceUpgrade(rs, this.isStoreByForeignSourceEnabled());
                if (intf.shouldMerge()) {
                    interfacesToMerge.add(intf);
                }
                this.log("  Should merge %s ? %s\n", intf, intf.shouldMerge());
            }
            this.log("  Found %s of %s SNMP interfaces that require a merge.\n", interfacesToMerge.size(), count);
        }
        catch (Throwable t) {
            this.log("Error: can't retrieve the required data from the OpenNMS Database or there were problems while processing them.\n", new Object[0]);
            String reason = t.getMessage();
            if (reason == null) {
                reason = "Unknown";
            }
            this.log("Reason(%s): %s\n", t.getClass().getName(), reason);
            t.printStackTrace();
        }
        finally {
            db.cleanUp();
        }
        return interfacesToMerge;
    }

    protected void merge(File oldDir, File newDir) throws Exception {
        this.log("Merging data from %s to %s\n", oldDir, newDir);
        if (newDir.exists()) {
            File[] rrdFiles = this.getFiles(oldDir, this.getRrdExtension());
            if (rrdFiles == null) {
                this.log("Warning: there are no %s files on %s\n", this.getRrdExtension(), oldDir);
            } else {
                for (File source : rrdFiles) {
                    File dest = new File(newDir, source.getName());
                    if (dest.exists()) {
                        if (this.isRrdToolEnabled()) {
                            this.mergeRrd(source, dest);
                            continue;
                        }
                        this.mergeJrb(source, dest);
                        continue;
                    }
                    this.log("  Warning: %s doesn't exist\n", dest);
                }
            }
            try {
                this.log("  removing old directory %s\n", oldDir.getName());
                FileUtils.deleteDirectory((File)oldDir);
            }
            catch (Exception e) {
                this.log("  Warning: can't delete old directory because %s", e.getMessage());
            }
        } else {
            try {
                this.log("  moving %s to %s\n", oldDir.getName(), newDir.getName());
                FileUtils.moveDirectory((File)oldDir, (File)newDir);
            }
            catch (Exception e) {
                this.log("  Warning: can't rename directory because %s", e.getMessage());
            }
        }
    }

    protected void mergeRrd(File source, File dest) throws Exception {
        this.log("  merging RRD %s into %s\n", source, dest);
        RRDv3 rrdSrc = RrdConvertUtils.dumpRrd((File)source);
        RRDv3 rrdDst = RrdConvertUtils.dumpRrd((File)dest);
        if (rrdSrc == null || rrdDst == null) {
            this.log("  Warning: can't load RRDs (ingoring merge).\n", new Object[0]);
            return;
        }
        rrdDst.merge((AbstractRRD)rrdSrc);
        File outputFile = new File(dest.getCanonicalPath() + ".merged");
        RrdConvertUtils.restoreRrd((RRDv3)rrdDst, (File)outputFile);
        if (dest.exists()) {
            FileUtils.deleteQuietly((File)dest);
        }
        FileUtils.moveFile((File)outputFile, (File)dest);
    }

    protected void mergeJrb(File source, File dest) throws Exception {
        this.log("  merging JRB %s into %s\n", source, dest);
        RRDv1 rrdSrc = RrdConvertUtils.dumpJrb((File)source);
        RRDv1 rrdDst = RrdConvertUtils.dumpJrb((File)dest);
        if (rrdSrc == null || rrdDst == null) {
            this.log("  Warning: can't load JRBs (ingoring merge).\n", new Object[0]);
            return;
        }
        rrdDst.merge((AbstractRRD)rrdSrc);
        File outputFile = new File(dest.getCanonicalPath() + ".merged");
        RrdConvertUtils.restoreJrb((RRDv1)rrdDst, (File)outputFile);
        if (dest.exists()) {
            FileUtils.deleteQuietly((File)dest);
        }
        FileUtils.moveFile((File)outputFile, (File)dest);
    }

    protected File getNodeDirectory(int nodeId, String foreignSource, String foreignId) {
        File dir = new File(DataCollectionConfigFactory.getInstance().getRrdPath(), String.valueOf(nodeId));
        if (Boolean.getBoolean("org.opennms.rrd.storeByForeignSource") && foreignSource != null && foreignId != null) {
            File fsDir = new File(DataCollectionConfigFactory.getInstance().getRrdPath(), "fs" + File.separatorChar + foreignSource);
            dir = new File(fsDir, foreignId);
        }
        return dir;
    }
}

