/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import com.atomikos.util.VersionedFile;
import java.io.FileOutputStream;
import java.io.IOException;

public class AbstractLogStream {
    protected static final Logger LOGGER = LoggerFactory.createLogger(AbstractLogStream.class);
    protected FileOutputStream output_;
    protected boolean simulateCrash_;
    protected boolean corrupt_;
    protected VersionedFile file_;

    public AbstractLogStream(String baseDir, String baseName) {
        this.file_ = new VersionedFile(baseDir, baseName, ".log");
        this.simulateCrash_ = false;
        this.corrupt_ = false;
    }

    protected void closeOutput() throws LogException {
        try {
            if (this.file_ != null) {
                this.file_.close();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("Logfile closed: " + this.file_.getCurrentVersionFileName());
                }
            }
            this.output_ = null;
        }
        catch (IOException e) {
            throw new LogException("Error closing previous output", e);
        }
    }

    public void setCrashMode() {
        this.simulateCrash_ = true;
    }

    public synchronized void close() throws LogException {
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public long getSize() throws LogException {
        return this.file_.getSize();
    }
}

