/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.RowSortedTable;
import java.util.Map;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;

@FilterInfo(name="Percentile", description="Calculates percentiles")
public class Percentile
implements Filter {
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="outputColumn", required=true, displayName="Output", description="Output column.")
    private String m_outputColumn;
    @FilterParam(key="quantile", value="0.95", displayName="Quantile", description="Quantile level. Must be > 0 and <= 1.")
    private double m_quantile;

    protected Percentile() {
    }

    public Percentile(String inputColumn, String outputColumn, double quantile) {
        this.m_inputColumn = inputColumn;
        this.m_outputColumn = outputColumn;
        this.m_quantile = quantile;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) {
        Map column = qrAsTable.column((Object)this.m_inputColumn);
        double[] values = new double[column.size()];
        int k = 0;
        for (Double value : column.values()) {
            values[k++] = value;
        }
        org.apache.commons.math3.stat.descriptive.rank.Percentile percentileCalculator = new org.apache.commons.math3.stat.descriptive.rank.Percentile();
        Double nthPercentile = percentileCalculator.evaluate(values, 100.0 * this.m_quantile);
        for (Long rowKey : column.keySet()) {
            qrAsTable.put((Object)rowKey, (Object)this.m_outputColumn, (Object)nthPercentile);
        }
    }
}

