/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.WriterListener;

public class ConsoleDebugger
implements SmackDebugger {
    public static boolean printInterpreted = false;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("hh:mm:ss aaa");
    private XMPPConnection connection = null;
    private PacketListener listener = null;
    private ConnectionListener connListener = null;
    private Writer writer;
    private Reader reader;
    private ReaderListener readerListener;
    private WriterListener writerListener;

    public ConsoleDebugger(XMPPConnection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = writer;
        this.reader = reader;
        this.createDebug();
    }

    private void createDebug() {
        ObservableReader debugReader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){

            @Override
            public void read(String str) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " RCV  (" + ConsoleDebugger.this.connection.hashCode() + "): " + str);
            }
        };
        debugReader.addReaderListener(this.readerListener);
        ObservableWriter debugWriter = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){

            @Override
            public void write(String str) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " SENT (" + ConsoleDebugger.this.connection.hashCode() + "): " + str);
            }
        };
        debugWriter.addWriterListener(this.writerListener);
        this.reader = debugReader;
        this.writer = debugWriter;
        this.listener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (printInterpreted) {
                    System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " RCV PKT (" + ConsoleDebugger.this.connection.hashCode() + "): " + packet.toXML());
                }
            }
        };
        this.connListener = new ConnectionListener(){

            @Override
            public void connected(XMPPConnection connection) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection connected (" + connection.hashCode() + ")");
            }

            @Override
            public void authenticated(XMPPConnection connection) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection authenticated (" + connection.hashCode() + ")");
            }

            @Override
            public void connectionClosed() {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection closed (" + ConsoleDebugger.this.connection.hashCode() + ")");
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection closed due to an exception (" + ConsoleDebugger.this.connection.hashCode() + ")");
                e.printStackTrace();
            }

            @Override
            public void reconnectionFailed(Exception e) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " Reconnection failed due to an exception (" + ConsoleDebugger.this.connection.hashCode() + ")");
                e.printStackTrace();
            }

            @Override
            public void reconnectionSuccessful() {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection reconnected (" + ConsoleDebugger.this.connection.hashCode() + ")");
            }

            @Override
            public void reconnectingIn(int seconds) {
                System.out.println(ConsoleDebugger.this.dateFormatter.format(new Date()) + " XMPPConnection (" + ConsoleDebugger.this.connection.hashCode() + ") will reconnect in " + seconds);
            }
        };
    }

    @Override
    public Reader newConnectionReader(Reader newReader) {
        ((ObservableReader)this.reader).removeReaderListener(this.readerListener);
        ObservableReader debugReader = new ObservableReader(newReader);
        debugReader.addReaderListener(this.readerListener);
        this.reader = debugReader;
        return this.reader;
    }

    @Override
    public Writer newConnectionWriter(Writer newWriter) {
        ((ObservableWriter)this.writer).removeWriterListener(this.writerListener);
        ObservableWriter debugWriter = new ObservableWriter(newWriter);
        debugWriter.addWriterListener(this.writerListener);
        this.writer = debugWriter;
        return this.writer;
    }

    @Override
    public void userHasLogged(String user) {
        boolean isAnonymous = "".equals(StringUtils.parseName(user));
        String title = "User logged (" + this.connection.hashCode() + "): " + (isAnonymous ? "" : StringUtils.parseBareAddress(user)) + "@" + this.connection.getServiceName() + ":" + this.connection.getPort();
        title = title + "/" + StringUtils.parseResource(user);
        System.out.println(title);
        this.connection.addConnectionListener(this.connListener);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public PacketListener getReaderListener() {
        return this.listener;
    }

    @Override
    public PacketListener getWriterListener() {
        return null;
    }
}

