/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.reporting.availability.Value;

@XmlRootElement(name="row")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Row
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    private List<Value> valueList = new ArrayList<Value>();

    public void addValue(Value vValue) throws IndexOutOfBoundsException {
        this.valueList.add(vValue);
    }

    public void addValue(int index, Value vValue) throws IndexOutOfBoundsException {
        this.valueList.add(index, vValue);
    }

    public Enumeration<Value> enumerateValue() {
        return Collections.enumeration(this.valueList);
    }

    public Value getValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IndexOutOfBoundsException("getValue: Index value '" + index + "' not in range [0.." + (this.valueList.size() - 1) + "]");
        }
        return this.valueList.get(index);
    }

    public Value[] getValue() {
        Value[] array = new Value[]{};
        return this.valueList.toArray(array);
    }

    public List<Value> getValueCollection() {
        return this.valueList;
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public Iterator<Value> iterateValue() {
        return this.valueList.iterator();
    }

    public void removeAllValue() {
        this.valueList.clear();
    }

    public boolean removeValue(Value vValue) {
        boolean removed = this.valueList.remove(vValue);
        return removed;
    }

    public Value removeValueAt(int index) {
        Value obj = this.valueList.remove(index);
        return obj;
    }

    @Hidden
    public void setValue(int index, Value vValue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.valueList.size()) {
            throw new IndexOutOfBoundsException("setValue: Index value '" + index + "' not in range [0.." + (this.valueList.size() - 1) + "]");
        }
        this.valueList.set(index, vValue);
    }

    @Hidden
    public void setValue(Value[] vValueArray) {
        this.valueList.clear();
        for (int i = 0; i < vValueArray.length; ++i) {
            this.valueList.add(vValueArray[i]);
        }
    }

    public void setValue(List<Value> vValueList) {
        this.valueList.clear();
        this.valueList.addAll(vValueList);
    }

    @Hidden
    public void setValueCollection(List<Value> valueList) {
        this.valueList = valueList;
    }
}

