/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.reporting.availability.CatSections;

@XmlRootElement(name="category")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Category
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="catName")
    private String catName;
    @XmlElement(name="catSections")
    private List<CatSections> catSectionsList = new ArrayList<CatSections>();
    @XmlElement(name="catComments")
    private String catComments;
    @XmlElement(name="warning")
    private Double warning;
    @XmlElement(name="normal")
    private Double normal;
    @XmlElement(name="catIndex")
    private Integer catIndex;
    @XmlElement(name="nodeCount")
    private Integer nodeCount;
    @XmlElement(name="ipaddrCount")
    private Integer ipaddrCount;
    @XmlElement(name="serviceCount")
    private Integer serviceCount;

    public void addCatSections(CatSections vCatSections) throws IndexOutOfBoundsException {
        this.catSectionsList.add(vCatSections);
    }

    public void addCatSections(int index, CatSections vCatSections) throws IndexOutOfBoundsException {
        this.catSectionsList.add(index, vCatSections);
    }

    public void deleteCatIndex() {
        this.catIndex = null;
    }

    public void deleteIpaddrCount() {
        this.ipaddrCount = null;
    }

    public void deleteNodeCount() {
        this.nodeCount = null;
    }

    public void deleteNormal() {
        this.normal = null;
    }

    public void deleteServiceCount() {
        this.serviceCount = null;
    }

    public void deleteWarning() {
        this.warning = null;
    }

    public Enumeration<CatSections> enumerateCatSections() {
        return Collections.enumeration(this.catSectionsList);
    }

    public String getCatComments() {
        return this.catComments;
    }

    public Integer getCatIndex() {
        return this.catIndex;
    }

    public String getCatName() {
        return this.catName;
    }

    public CatSections getCatSections(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.catSectionsList.size()) {
            throw new IndexOutOfBoundsException("getCatSections: Index value '" + index + "' not in range [0.." + (this.catSectionsList.size() - 1) + "]");
        }
        return this.catSectionsList.get(index);
    }

    public CatSections[] getCatSections() {
        CatSections[] array = new CatSections[]{};
        return this.catSectionsList.toArray(array);
    }

    public List<CatSections> getCatSectionsCollection() {
        return this.catSectionsList;
    }

    public int getCatSectionsCount() {
        return this.catSectionsList.size();
    }

    public Integer getIpaddrCount() {
        return this.ipaddrCount;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Double getNormal() {
        return this.normal;
    }

    public Integer getServiceCount() {
        return this.serviceCount;
    }

    public Double getWarning() {
        return this.warning;
    }

    public boolean hasCatIndex() {
        return this.catIndex != null;
    }

    public boolean hasIpaddrCount() {
        return this.ipaddrCount != null;
    }

    public boolean hasNodeCount() {
        return this.nodeCount != null;
    }

    public boolean hasNormal() {
        return this.normal != null;
    }

    public boolean hasServiceCount() {
        return this.serviceCount != null;
    }

    public boolean hasWarning() {
        return this.warning != null;
    }

    public Iterator<CatSections> iterateCatSections() {
        return this.catSectionsList.iterator();
    }

    public void removeAllCatSections() {
        this.catSectionsList.clear();
    }

    public boolean removeCatSections(CatSections vCatSections) {
        boolean removed = this.catSectionsList.remove(vCatSections);
        return removed;
    }

    public CatSections removeCatSectionsAt(int index) {
        CatSections obj = this.catSectionsList.remove(index);
        return obj;
    }

    public void setCatComments(String catComments) {
        this.catComments = catComments;
    }

    public void setCatIndex(Integer catIndex) {
        this.catIndex = catIndex;
    }

    public void setCatName(String catName) {
        this.catName = catName;
    }

    @Hidden
    public void setCatSections(int index, CatSections vCatSections) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.catSectionsList.size()) {
            throw new IndexOutOfBoundsException("setCatSections: Index value '" + index + "' not in range [0.." + (this.catSectionsList.size() - 1) + "]");
        }
        this.catSectionsList.set(index, vCatSections);
    }

    @Hidden
    public void setCatSections(CatSections[] vCatSectionsArray) {
        this.catSectionsList.clear();
        for (int i = 0; i < vCatSectionsArray.length; ++i) {
            this.catSectionsList.add(vCatSectionsArray[i]);
        }
    }

    public void setCatSections(List<CatSections> vCatSectionsList) {
        this.catSectionsList.clear();
        this.catSectionsList.addAll(vCatSectionsList);
    }

    @Hidden
    public void setCatSectionsCollection(List<CatSections> catSectionsList) {
        this.catSectionsList = catSectionsList;
    }

    public void setIpaddrCount(Integer ipaddrCount) {
        this.ipaddrCount = ipaddrCount;
    }

    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    public void setNormal(Double normal) {
        this.normal = normal;
    }

    public void setServiceCount(Integer serviceCount) {
        this.serviceCount = serviceCount;
    }

    public void setWarning(Double warning) {
        this.warning = warning;
    }
}

