/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.nominatim;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONTokener;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderResult;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.nominatim.NominatimConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NominatimGeocoderService
implements GeocoderService {
    private static final Logger LOG = LoggerFactory.getLogger(NominatimGeocoderService.class);
    private final NominatimConfiguration configuration;

    public NominatimGeocoderService(NominatimConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public String getId() {
        return "nominatim";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public GeocoderResult resolveAddress(String address) throws GeocoderConfigurationException {
        this.configuration.validate();
        NominatimGeocoderService.LOG.debug("Configuration: {}", this.configuration.asMap());
        try {
            clientWrapper = HttpClientWrapper.create().dontReuseConnections();
            try {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                block21: {
                                    block22: {
                                        if (this.configuration.isUseSystemProxy()) {
                                            clientWrapper.useSystemProxySettings();
                                        }
                                        url = this.buildUrl(this.configuration.getEmailAddress(), address);
                                        method = new HttpGet(url);
                                        if (!Strings.isNullOrEmpty((String)this.configuration.getUserAgent())) {
                                            method.addHeader("User-Agent", this.configuration.getUserAgent());
                                        }
                                        if (!Strings.isNullOrEmpty((String)this.configuration.getReferer())) {
                                            method.addHeader("Referer", this.configuration.getReferer());
                                        }
                                        response = clientWrapper.execute((HttpUriRequest)method);
                                        try {
                                            statusLine = response.getStatusLine();
                                            NominatimGeocoderService.LOG.trace("Invoking URL {} returned {}:{} => {}", new Object[]{url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), statusLine.getStatusCode() == 200 ? "OK" : "NOK"});
                                            if (statusLine.getStatusCode() == 200) break block21;
                                            var7_11 = GeocoderResult.error((String)String.format("Nominatim returned a non-OK response code: %s: %s", new Object[]{statusLine.getStatusCode(), statusLine.getReasonPhrase()})).build();
                                            if (response == null) break block22;
                                        }
                                        catch (Throwable var6_10) {
                                            if (response != null) {
                                                try {
                                                    response.close();
                                                }
                                                catch (Throwable var7_13) {
                                                    var6_10.addSuppressed(var7_13);
                                                }
                                            }
                                            throw var6_10;
                                        }
                                        response.close();
                                    }
                                    return var7_11;
                                }
                                responseStream = response.getEntity().getContent();
                                tokener = new JSONTokener(responseStream);
                                results = new JSONArray(tokener);
                                if (results.length() <= 0) ** GOTO lbl57
                                NominatimGeocoderService.LOG.trace("API returned {} of results. If multiple, the first is used.", (Object)results.length());
                                result = results.getJSONObject(0);
                                if (!result.has("lat") || !result.has("lon")) break block23;
                                longitude = Float.valueOf(result.getFloat("lon"));
                                latitude = Float.valueOf(result.getFloat("lat"));
                                NominatimGeocoderService.LOG.trace("API returned a result with valid long/lat fields: {}/{}", (Object)longitude, (Object)latitude);
                                var13_19 = GeocoderResult.success((String)address, (double)longitude.floatValue(), (double)latitude.floatValue()).build();
                                if (response == null) break block24;
                                response.close();
                            }
                            return var13_19;
                        }
                        NominatimGeocoderService.LOG.trace("API returned a result which does not contain lon/lat fields: {}", (Object)result);
                        break block26;
lbl57:
                        // 1 sources

                        NominatimGeocoderService.LOG.trace("API returned an empty result");
                    }
                    NominatimGeocoderService.LOG.debug("Couldn't resolve coordinates for address {}", (Object)address);
                    var10_16 = GeocoderResult.noResult((String)address).build();
                    if (response == null) break block25;
                    response.close();
                }
                return var10_16;
            }
            finally {
                if (clientWrapper != null) {
                    clientWrapper.close();
                }
            }
        }
        catch (IOException e) {
            return GeocoderResult.error((Exception)e).build();
        }
    }

    public NominatimConfiguration getConfiguration() {
        return this.configuration;
    }

    public void validateConfiguration(Map<String, Object> properties) throws GeocoderConfigurationException {
        NominatimConfiguration.fromMap(properties).validate();
    }

    private String buildUrl(String emailAddress, String addressToResolve) throws UnsupportedEncodingException {
        Objects.requireNonNull(emailAddress);
        Objects.requireNonNull(addressToResolve);
        String url = this.configuration.getUrlTemplate().replaceAll("\\{email\\}", URLEncoder.encode(emailAddress, "UTF-8")).replaceAll("\\{query\\}", URLEncoder.encode(addressToResolve, "UTF-8"));
        return url;
    }
}

