/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.snmp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.service.snmp.IpAddressTableEntry;
import org.opennms.netmgt.provision.service.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public class IpAddressTable
extends SnmpTable<IpAddressTableEntry> {
    protected static final int INSTANCE_TYPE_IPV4 = 1;
    protected static final int INSTANCE_TYPE_IPV6 = 2;
    private final Set<InetAddress> m_addresses;

    public IpAddressTable(InetAddress address) {
        super(address, "ipAddressTable", IpAddressTableEntry.ms_elemList);
        this.m_addresses = Collections.emptySet();
    }

    public IpAddressTable(InetAddress address, Set<InetAddress> inetAddresses, Set<SnmpInstId> ipAddresses) {
        super(address, "IpAddressTable", IpAddressTableEntry.ms_elemList, ipAddresses);
        this.m_addresses = inetAddresses;
    }

    @Override
    protected IpAddressTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddressTableEntry();
    }

    public Set<Integer> getIfIndices() {
        TreeSet<Integer> ifIndices = new TreeSet<Integer>();
        for (IpAddressTableEntry entry : this.getEntries()) {
            Integer ifIndex = entry.getIpAddressIfIndex();
            if (ifIndex == null) continue;
            ifIndices.add(ifIndex);
        }
        return ifIndices;
    }

    public InetAddress getIfAddress(int ifIndex) {
        IpAddressTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAddress();
    }

    public InetAddress getNetMask(int ifIndex) {
        IpAddressTableEntry entry = this.getEntryByIfIndex(ifIndex);
        return entry == null ? null : entry.getIpAddressNetMask();
    }

    public InetAddress getNetMask(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAddressNetMask();
    }

    public Integer getIfIndex(InetAddress address) {
        return this.getEntry(address) == null ? null : this.getEntry(address).getIpAddressIfIndex();
    }

    public IpAddressTableEntry getEntryByIfIndex(int ifIndex) {
        if (this.getEntries() == null) {
            return null;
        }
        for (IpAddressTableEntry entry : this.getEntries()) {
            Integer ndx = entry.getIpAddressIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            return entry;
        }
        return null;
    }

    public IpAddressTableEntry getEntry(InetAddress address) {
        return (IpAddressTableEntry)((Object)this.getEntry(IpAddressTable.getInstanceForAddress(address)));
    }

    public void updateIpInterfaceData(OnmsNode node) {
        for (IpAddressTableEntry entry : this.getEntries()) {
            this.updateIpInterfaceData(node, entry.getIpAddress());
        }
    }

    public boolean updateIpInterfaceData(OnmsNode node, InetAddress ipAddr) {
        InetAddress inetAddr;
        Integer ifIndex;
        boolean newIpInterfaceCreated = false;
        OnmsIpInterface ipIf = node.getIpInterfaceByIpAddress(ipAddr);
        if (ipIf == null) {
            ipIf = new OnmsIpInterface(ipAddr, node);
            newIpInterfaceCreated = true;
        }
        if ((ifIndex = this.getIfIndex(inetAddr = ipIf.getIpAddress())) != null) {
            InetAddress mask;
            OnmsSnmpInterface snmpIf = node.getSnmpInterfaceWithIfIndex(ifIndex.intValue());
            if (snmpIf == null) {
                snmpIf = new OnmsSnmpInterface(node, ifIndex);
            }
            if ((mask = this.getNetMask(inetAddr)) != null) {
                ipIf.setNetMask(mask);
            }
            snmpIf.setCollectionEnabled(true);
            ipIf.setSnmpInterface(snmpIf);
        }
        return newIpInterfaceCreated;
    }

    public Set<String> getIpAddresses() {
        LinkedHashSet<String> ipAddrs = new LinkedHashSet<String>();
        for (InetAddress addr : this.m_addresses) {
            ipAddrs.add(InetAddressUtils.str((InetAddress)addr));
        }
        return ipAddrs;
    }

    public static IpAddressTable createTable(InetAddress address, Set<InetAddress> ipAddresses) {
        return new IpAddressTable(address, ipAddresses, IpAddressTable.getInstanceIds(ipAddresses));
    }

    public static Set<SnmpInstId> getInstanceIds(Set<InetAddress> ipAddresses) {
        HashSet<SnmpInstId> ids = new HashSet<SnmpInstId>();
        for (InetAddress addr : ipAddresses) {
            ids.add(IpAddressTable.getInstanceForAddress(addr));
        }
        return ids;
    }

    public static SnmpInstId getInstanceForAddress(InetAddress address) {
        int type;
        if (address instanceof Inet4Address) {
            type = 1;
        } else if (address instanceof Inet6Address) {
            type = 2;
        } else {
            return null;
        }
        return new SnmpInstId(type + "." + address.getAddress().length + "." + InetAddressUtils.toOid((InetAddress)address));
    }
}

