/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.lifecycle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.netmgt.provision.service.lifecycle.DefaultLifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycle;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleInstance;
import org.opennms.netmgt.provision.service.lifecycle.LifeCycleRepository;

public class DefaultLifeCycleRepository
implements LifeCycleRepository {
    private final Map<String, LifeCycle> m_lifeCycles = new HashMap<String, LifeCycle>();
    private final TaskCoordinator m_coordinator;

    public DefaultLifeCycleRepository(TaskCoordinator coordinator) {
        this.m_coordinator = coordinator;
    }

    @Override
    public LifeCycleInstance createNestedLifeCycleInstance(BatchTask containingPhase, String lifeCycleName, Object ... providers) {
        LifeCycle lifeCycle = this.getLifeCycle(lifeCycleName);
        return new DefaultLifeCycleInstance(containingPhase, this, this.m_coordinator, lifeCycle.getLifeCycleName(), lifeCycle.getPhaseNames(), providers);
    }

    @Override
    public LifeCycleInstance createLifeCycleInstance(String lifeCycleName, Object ... providers) {
        LifeCycle lifeCycle = this.getLifeCycle(lifeCycleName);
        return new DefaultLifeCycleInstance(this, this.m_coordinator, lifeCycle.getLifeCycleName(), lifeCycle.getPhaseNames(), providers);
    }

    private LifeCycle getLifeCycle(String lifeCycleName) {
        LifeCycle lifeCycle = this.m_lifeCycles.get(lifeCycleName);
        if (lifeCycle == null) {
            throw new IllegalArgumentException("Unable to find a definition for lifecycle " + lifeCycleName);
        }
        return lifeCycle;
    }

    public void addLifeCycle(LifeCycle lifeCycle) {
        this.m_lifeCycles.put(lifeCycle.getLifeCycleName(), lifeCycle);
    }

    public void setLifeCycles(List<LifeCycle> lifecycles) {
        this.m_lifeCycles.clear();
        for (LifeCycle l : lifecycles) {
            this.addLifeCycle(l);
        }
    }
}

