/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import io.opentracing.Span;
import java.net.InetAddress;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.DefaultProvisionService;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.Scan;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionOverallMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewSuspectScan
implements Scan {
    private static final Logger LOG = LoggerFactory.getLogger(NewSuspectScan.class);
    private String m_location;
    private InetAddress m_ipAddress;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private TaskCoordinator m_taskCoordinator;
    private String m_foreignSource;
    private Span m_span;
    private ProvisionMonitor monitor;
    private ProvisionOverallMonitor overallMonitor;

    public NewSuspectScan(InetAddress ipAddress, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, TaskCoordinator taskCoordinator, String foreignSource, String location, ProvisionMonitor monitor, ProvisionOverallMonitor overallMonitor) {
        this.m_ipAddress = ipAddress;
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
        this.m_foreignSource = foreignSource;
        this.m_location = location;
        this.monitor = monitor;
        this.overallMonitor = overallMonitor;
    }

    @Override
    public Task createTask() {
        return this.m_taskCoordinator.createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask phase) {
        this.m_span = this.m_provisionService.buildAndStartSpan("NewSuspectScan", null);
        this.scanUndiscoveredNode(phase, this.monitor);
    }

    protected void scanUndiscoveredNode(BatchTask phase, ProvisionMonitor monitor) {
        final String addrString = InetAddressUtils.str((InetAddress)this.m_ipAddress);
        LOG.info("Attempting to scan new suspect address {} for foreign source {}", (Object)addrString, (Object)this.m_foreignSource);
        final OnmsNode node = this.m_provisionService.createUndiscoveredNode(addrString, this.m_foreignSource, this.m_location, monitor != null ? monitor.getName() : null);
        if (node != null) {
            if (node.getId() != null && node.getId() > 0) {
                this.m_span.setTag("nodeId", (Number)node.getId());
                this.m_span.setTag("location", this.m_location);
            }
            phase.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(node, this.m_ipAddress, null, node.getLocation(), this.createScanProgress(), this.m_agentConfigFactory, this.m_provisionService, null, this.m_span), new IpInterfaceScan(node.getId(), this.m_ipAddress, this.m_foreignSource, node.getLocation(), this.m_provisionService, this.m_span), new NodeScan(node.getId(), this.m_foreignSource, node.getForeignId(), node.getLocation(), this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator, this.m_span, monitor, this.overallMonitor), new RunInBatch(){

                public void run(BatchTask batch) {
                    LOG.info("Done scanning scan new suspect address {} for foreign source {}", (Object)addrString, (Object)NewSuspectScan.this.m_foreignSource);
                    DefaultProvisionService.setTag(NewSuspectScan.this.m_span, "foreignId", node.getForeignId());
                    DefaultProvisionService.setTag(NewSuspectScan.this.m_span, "foreignSource", node.getForeignSource());
                    NewSuspectScan.this.m_span.finish();
                }
            }});
        } else {
            LOG.info("A node already exists with address {} in foreign source {}. No node scan will be performed.", (Object)addrString, (Object)this.m_foreignSource);
        }
    }

    private ScanProgress createScanProgress() {
        return new ScanProgress(){
            private boolean m_aborted = false;

            @Override
            public void abort(String message) {
                this.m_aborted = true;
                NewSuspectScan.this.m_span.setTag("error", true);
                NewSuspectScan.this.m_span.setTag("abort", true);
                NewSuspectScan.this.m_span.log(message);
                LOG.info(message);
            }

            @Override
            public boolean isAborted() {
                return this.m_aborted;
            }
        };
    }

    protected void reparentNodes(BatchTask batch, Integer nodeId) {
        LOG.debug("reparenting node ID {} not supported", (Object)nodeId);
    }
}

