/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.LocationAwareDnsLookupClient;
import org.opennms.netmgt.provision.service.HostnameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultHostnameResolver
implements HostnameResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHostnameResolver.class);
    private final LocationAwareDnsLookupClient m_locationAwareDnsLookupClient;

    public DefaultHostnameResolver(LocationAwareDnsLookupClient locationAwareDnsLookupClient) {
        this.m_locationAwareDnsLookupClient = Objects.requireNonNull(locationAwareDnsLookupClient);
    }

    @Override
    public CompletableFuture<String> getHostnameAsync(InetAddress addr, String location) {
        LOG.debug("Performing reverse lookup on {} at location {}", (Object)addr, (Object)location);
        return this.m_locationAwareDnsLookupClient.reverseLookup(addr, location).handle((result, e) -> {
            if (e == null) {
                LOG.debug("Reverse lookup returned {} for {} at location {}", new Object[]{result, addr, location});
                return result;
            }
            LOG.warn("Reverse lookup failed for {} at location {}. Using IP address as hostname.", (Object)addr, (Object)location);
            return InetAddressUtils.str((InetAddress)addr);
        });
    }
}

