/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.opennms.core.xml.JaxbUtils;

public class XmlHandler<U> {
    private final Class<U> clazz;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public XmlHandler(Class<U> clazz) {
        JAXBContext context;
        this.clazz = clazz;
        try {
            context = JaxbUtils.getContextFor(clazz);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.marshaller = JaxbUtils.getMarshallerFor(clazz, context);
        this.unmarshaller = JaxbUtils.getUnmarshallerFor(clazz, context, false);
        try {
            this.unmarshaller.setEventHandler((ValidationEventHandler)new JaxbUtils.LoggingValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new RuntimeException("An error was encountered while setting the event handler", e);
        }
    }

    public String marshal(U obj) {
        StringWriter jaxbWriter = new StringWriter();
        try {
            this.marshaller.marshal(obj, (Writer)jaxbWriter);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return jaxbWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public U unmarshal(String xml) {
        try (StringReader sr = new StringReader(xml);){
            U u = this.clazz.cast(this.unmarshaller.unmarshal((Reader)sr));
            return u;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

