/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dhcp4java.DHCPBadPacketException;
import org.dhcp4java.DHCPConstants;
import org.dhcp4java.DHCPOption;
import org.dhcp4java.HardwareAddress;
import org.dhcp4java.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPPacket
implements Cloneable,
Serializable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DHCPPacket.class);
    private String m_sComment = "";
    private byte m_nOp = (byte)2;
    private byte m_nHtype = 1;
    private byte m_nHlen = (byte)6;
    private byte m_nHops;
    private int m_nXid;
    private short m_nSecs;
    private short m_nFlags;
    private byte[] m_aCiaddr = new byte[4];
    private byte[] m_aYiaddr = new byte[4];
    private byte[] m_aSiaddr = new byte[4];
    private byte[] m_aGiaddr = new byte[4];
    private byte[] m_aChaddr = new byte[16];
    private byte[] m_aSname = new byte[64];
    private byte[] m_aFile = new byte[128];
    private Map<Byte, DHCPOption> m_aOptions;
    private boolean m_bIsDhcp = true;
    private boolean m_bTruncated;
    private byte[] m_aPadding = new byte[0];
    private InetAddress m_aAddress;
    private int m_nPort;

    public DHCPPacket() {
        this.m_aOptions = new LinkedHashMap<Byte, DHCPOption>();
    }

    public static DHCPPacket getPacket(DatagramPacket datagramPacket) throws DHCPBadPacketException {
        if (datagramPacket == null) {
            throw new IllegalArgumentException("datagram is null");
        }
        DHCPPacket dHCPPacket = new DHCPPacket();
        dHCPPacket.marshall(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort(), true);
        return dHCPPacket;
    }

    public static DHCPPacket getPacket(byte[] byArray, int n, int n2, boolean bl) throws DHCPBadPacketException {
        DHCPPacket dHCPPacket = new DHCPPacket();
        dHCPPacket.marshall(byArray, n, n2, null, 0, bl);
        return dHCPPacket;
    }

    public DHCPPacket clone() {
        try {
            DHCPPacket dHCPPacket = (DHCPPacket)super.clone();
            dHCPPacket.m_aCiaddr = (byte[])this.m_aCiaddr.clone();
            dHCPPacket.m_aYiaddr = (byte[])this.m_aYiaddr.clone();
            dHCPPacket.m_aSiaddr = (byte[])this.m_aSiaddr.clone();
            dHCPPacket.m_aGiaddr = (byte[])this.m_aGiaddr.clone();
            dHCPPacket.m_aChaddr = (byte[])this.m_aChaddr.clone();
            dHCPPacket.m_aSname = (byte[])this.m_aSname.clone();
            dHCPPacket.m_aFile = (byte[])this.m_aFile.clone();
            dHCPPacket.m_aOptions = new LinkedHashMap<Byte, DHCPOption>(this.m_aOptions);
            dHCPPacket.m_aPadding = (byte[])this.m_aPadding.clone();
            dHCPPacket.m_bTruncated = false;
            return dHCPPacket;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof DHCPPacket)) {
            return false;
        }
        DHCPPacket dHCPPacket = (DHCPPacket)object;
        return this.m_sComment.equals(dHCPPacket.m_sComment) && this.m_nOp == dHCPPacket.m_nOp && this.m_nHtype == dHCPPacket.m_nHtype && this.m_nHlen == dHCPPacket.m_nHlen && this.m_nHops == dHCPPacket.m_nHops && this.m_nXid == dHCPPacket.m_nXid && this.m_nSecs == dHCPPacket.m_nSecs && this.m_nFlags == dHCPPacket.m_nFlags && Arrays.equals(this.m_aCiaddr, dHCPPacket.m_aCiaddr) && Arrays.equals(this.m_aYiaddr, dHCPPacket.m_aYiaddr) && Arrays.equals(this.m_aSiaddr, dHCPPacket.m_aSiaddr) && Arrays.equals(this.m_aGiaddr, dHCPPacket.m_aGiaddr) && Arrays.equals(this.m_aChaddr, dHCPPacket.m_aChaddr) && Arrays.equals(this.m_aSname, dHCPPacket.m_aSname) && Arrays.equals(this.m_aFile, dHCPPacket.m_aFile) && this.m_aOptions.equals(dHCPPacket.m_aOptions) && this.m_bIsDhcp == dHCPPacket.m_bIsDhcp && Arrays.equals(this.m_aPadding, dHCPPacket.m_aPadding) && DHCPPacket._equalsStatic(this.m_aAddress, dHCPPacket.m_aAddress) && this.m_nPort == dHCPPacket.m_nPort;
    }

    public int hashCode() {
        int n = -1;
        n ^= this.m_sComment.hashCode();
        n += this.m_nOp;
        n += this.m_nHtype;
        n += this.m_nHlen;
        n += this.m_nHops;
        n += this.m_nXid;
        n += this.m_nSecs;
        n ^= this.m_nFlags;
        n ^= Arrays.hashCode(this.m_aCiaddr);
        n ^= Arrays.hashCode(this.m_aYiaddr);
        n ^= Arrays.hashCode(this.m_aSiaddr);
        n ^= Arrays.hashCode(this.m_aGiaddr);
        n ^= Arrays.hashCode(this.m_aChaddr);
        n ^= Arrays.hashCode(this.m_aSname);
        n ^= Arrays.hashCode(this.m_aFile);
        n ^= this.m_aOptions.hashCode();
        n += this.m_bIsDhcp ? 1 : 0;
        n ^= Arrays.hashCode(this.m_aPadding);
        n ^= this.m_aAddress != null ? this.m_aAddress.hashCode() : 0;
        return n += this.m_nPort;
    }

    private static boolean _equalsStatic(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void _assertInvariants() {
        assert (this.m_sComment != null);
        assert (this.m_aCiaddr != null);
        assert (this.m_aCiaddr.length == 4);
        assert (this.m_aYiaddr != null);
        assert (this.m_aYiaddr.length == 4);
        assert (this.m_aSiaddr != null);
        assert (this.m_aSiaddr.length == 4);
        assert (this.m_aGiaddr != null);
        assert (this.m_aGiaddr.length == 4);
        assert (this.m_aChaddr != null);
        assert (this.m_aChaddr.length == 16);
        assert (this.m_aSname != null);
        assert (this.m_aSname.length == 64);
        assert (this.m_aFile != null);
        assert (this.m_aFile.length == 128);
        assert (this.m_aPadding != null);
        assert (this.m_aOptions != null);
        for (Map.Entry<Byte, DHCPOption> entry : this.m_aOptions.entrySet()) {
            Byte by = entry.getKey();
            DHCPOption dHCPOption = entry.getValue();
            assert (by != null);
            assert (by != 0);
            assert (by != -1);
            assert (dHCPOption != null);
            assert (dHCPOption.getCode() == by.byteValue());
            assert (dHCPOption.getValueFast() != null);
        }
    }

    protected DHCPPacket marshall(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("null buffer not allowed");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative offset not allowed");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative length not allowed");
        }
        if (byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("offset+length exceeds buffer length");
        }
        if (n2 < 236) {
            throw new DHCPBadPacketException("DHCP Packet too small (" + n2 + ") absolute minimum is " + 236);
        }
        if (n2 > 1500) {
            throw new DHCPBadPacketException("DHCP Packet too big (" + n2 + ") max MTU is " + 1500);
        }
        this.m_aAddress = inetAddress;
        this.m_nPort = n3;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.m_nOp = dataInputStream.readByte();
            this.m_nHtype = dataInputStream.readByte();
            this.m_nHlen = dataInputStream.readByte();
            this.m_nHops = dataInputStream.readByte();
            this.m_nXid = dataInputStream.readInt();
            this.m_nSecs = dataInputStream.readShort();
            this.m_nFlags = dataInputStream.readShort();
            dataInputStream.readFully(this.m_aCiaddr, 0, 4);
            dataInputStream.readFully(this.m_aYiaddr, 0, 4);
            dataInputStream.readFully(this.m_aSiaddr, 0, 4);
            dataInputStream.readFully(this.m_aGiaddr, 0, 4);
            dataInputStream.readFully(this.m_aChaddr, 0, 16);
            dataInputStream.readFully(this.m_aSname, 0, 64);
            dataInputStream.readFully(this.m_aFile, 0, 128);
            this.m_bIsDhcp = true;
            byteArrayInputStream.mark(4);
            if (dataInputStream.readInt() != 1669485411) {
                this.m_bIsDhcp = false;
                byteArrayInputStream.reset();
            }
            if (this.m_bIsDhcp) {
                int n4;
                byte by = 0;
                while ((n4 = byteArrayInputStream.read()) >= 0) {
                    by = (byte)n4;
                    if (by == 0) continue;
                    if (by == -1 || (n4 = byteArrayInputStream.read()) < 0) break;
                    int n5 = Math.min(n4, byteArrayInputStream.available());
                    byte[] byArray2 = new byte[n5];
                    byteArrayInputStream.read(byArray2);
                    this.setOption(new DHCPOption(by, byArray2));
                }
                boolean bl2 = this.m_bTruncated = by != -1;
                if (bl && this.m_bTruncated) {
                    throw new DHCPBadPacketException("Packet seams to be truncated");
                }
            }
            this.m_aPadding = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(this.m_aPadding);
            this._assertInvariants();
            return this;
        }
        catch (IOException iOException) {
            throw new DHCPBadPacketException("IOException: " + iOException.toString(), iOException);
        }
    }

    public byte[] serialize() {
        int n = 236;
        if (this.m_bIsDhcp) {
            n += 64;
        }
        return this.serialize(n, 576);
    }

    public byte[] serialize(int n, int n2) {
        this._assertInvariants();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(750);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            dataOutputStream.writeByte(this.m_nOp);
            dataOutputStream.writeByte(this.m_nHtype);
            dataOutputStream.writeByte(this.m_nHlen);
            dataOutputStream.writeByte(this.m_nHops);
            dataOutputStream.writeInt(this.m_nXid);
            dataOutputStream.writeShort(this.m_nSecs);
            dataOutputStream.writeShort(this.m_nFlags);
            dataOutputStream.write(this.m_aCiaddr, 0, 4);
            dataOutputStream.write(this.m_aYiaddr, 0, 4);
            dataOutputStream.write(this.m_aSiaddr, 0, 4);
            dataOutputStream.write(this.m_aGiaddr, 0, 4);
            dataOutputStream.write(this.m_aChaddr, 0, 16);
            dataOutputStream.write(this.m_aSname, 0, 64);
            dataOutputStream.write(this.m_aFile, 0, 128);
            if (this.m_bIsDhcp) {
                dataOutputStream.writeInt(1669485411);
                for (DHCPOption object2 : this.getOptionsCollection()) {
                    assert (object2 != null);
                    assert (object2.getCode() != 0);
                    assert (object2.getCode() != -1);
                    assert (object2.getValueFast() != null);
                    int n3 = object2.getValueFast().length;
                    assert (n3 >= 0);
                    if (n3 > 255) {
                        throw new DHCPBadPacketException("Options larger than 255 bytes are not yet supported");
                    }
                    dataOutputStream.writeByte(object2.getCode());
                    dataOutputStream.writeByte(n3);
                    dataOutputStream.write(object2.getValueFast());
                }
                dataOutputStream.writeByte(-1);
            }
            dataOutputStream.write(this.m_aPadding);
            int n4 = n - byteArrayOutputStream.size();
            if (n4 > 0) {
                byte[] byArray2 = new byte[n4];
                dataOutputStream.write(byArray2);
            }
            if ((byArray = byteArrayOutputStream.toByteArray()).length > 1500) {
                throw new DHCPBadPacketException("serialize: packet too big (" + byArray.length + " greater than max MAX_MTU (" + 1500 + ')');
            }
            return byArray;
        }
        catch (IOException iOException) {
            s_aLogger.error("Unexpected Exception", (Throwable)iOException);
            throw new DHCPBadPacketException("IOException raised: " + iOException.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.m_bIsDhcp ? "DHCP Packet" : "BOOTP Packet").append("\ncomment=").append(this.m_sComment).append("\naddress=").append(this.m_aAddress != null ? this.m_aAddress.getHostAddress() : "").append('(').append(this.m_nPort).append(')').append("\nop=");
            String string = DHCPConstants._BOOT_NAMES.get(this.m_nOp);
            if (string != null) {
                stringBuilder.append(string).append('(').append(this.m_nOp).append(')');
            } else {
                stringBuilder.append(this.m_nOp);
            }
            stringBuilder.append("\nhtype=");
            String string2 = DHCPConstants._HTYPE_NAMES.get(this.m_nHtype);
            if (string2 != null) {
                stringBuilder.append(string2).append('(').append(this.m_nHtype).append(')');
            } else {
                stringBuilder.append(this.m_nHtype);
            }
            stringBuilder.append("\nhlen=").append(this.m_nHlen).append("\nhops=").append(this.m_nHops).append("\nxid=0x");
            Util.appendHex(stringBuilder, this.m_nXid);
            stringBuilder.append("\nsecs=").append(this.m_nSecs).append("\nflags=0x").append(Integer.toHexString(this.m_nFlags)).append("\nciaddr=");
            Util.appendHostAddress(stringBuilder, InetAddress.getByAddress(this.m_aCiaddr));
            stringBuilder.append("\nyiaddr=");
            Util.appendHostAddress(stringBuilder, InetAddress.getByAddress(this.m_aYiaddr));
            stringBuilder.append("\nsiaddr=");
            Util.appendHostAddress(stringBuilder, InetAddress.getByAddress(this.m_aSiaddr));
            stringBuilder.append("\ngiaddr=");
            Util.appendHostAddress(stringBuilder, InetAddress.getByAddress(this.m_aGiaddr));
            stringBuilder.append("\nchaddr=0x");
            this._appendChaddrAsHex(stringBuilder);
            stringBuilder.append("\nsname=").append(this.getSname()).append("\nfile=").append(this.getFile());
            if (this.m_bIsDhcp) {
                stringBuilder.append("\nOptions follows:");
                for (DHCPOption dHCPOption : this.getOptionsCollection()) {
                    stringBuilder.append('\n');
                    dHCPOption.append(stringBuilder);
                }
            }
            stringBuilder.append("\npadding[").append(this.m_aPadding.length).append("]=");
            Util.appendHex(stringBuilder, this.m_aPadding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public String getComment() {
        return this.m_sComment;
    }

    public void setComment(String string) {
        this.m_sComment = string;
    }

    public byte[] getChaddr() {
        return (byte[])this.m_aChaddr.clone();
    }

    private StringBuilder _appendChaddrAsHex(StringBuilder stringBuilder) {
        Util.appendHex(stringBuilder, this.m_aChaddr, 0, this.m_nHlen & 0xFF);
        return stringBuilder;
    }

    public HardwareAddress getHardwareAddress() {
        int n = this.m_nHlen & 0xFF;
        if (n > 16) {
            n = 16;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_aChaddr, 0, byArray, 0, n);
        return new HardwareAddress(this.m_nHtype, byArray);
    }

    public String getChaddrAsHex() {
        return this._appendChaddrAsHex(new StringBuilder(this.m_nHlen & 0xFF)).toString();
    }

    public void setChaddr(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length > this.m_aChaddr.length) {
                throw new IllegalArgumentException("chaddr is too long: " + byArray.length + ", max is: " + this.m_aChaddr.length);
            }
            Arrays.fill(this.m_aChaddr, (byte)0);
            System.arraycopy(byArray, 0, this.m_aChaddr, 0, byArray.length);
        } else {
            Arrays.fill(this.m_aChaddr, (byte)0);
        }
    }

    public void setChaddrHex(String string) {
        this.setChaddr(Util.hex2Bytes(string));
    }

    public InetAddress getCiaddr() {
        try {
            return InetAddress.getByAddress(this.getCiaddrRaw());
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public byte[] getCiaddrRaw() {
        return (byte[])this.m_aCiaddr.clone();
    }

    public void setCiaddr(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setCiaddrRaw(inetAddress.getAddress());
    }

    public void setCiaddr(String string) throws UnknownHostException {
        this.setCiaddr(InetAddress.getByName(string));
    }

    public void setCiaddrRaw(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(byArray, 0, this.m_aCiaddr, 0, 4);
    }

    public byte[] getFileRaw() {
        return (byte[])this.m_aFile.clone();
    }

    public String getFile() {
        return Util.bytesToString(this.getFileRaw());
    }

    public void setFile(String string) {
        this.setFileRaw(Util.stringToBytes(string));
    }

    public void setFileRaw(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length > this.m_aFile.length) {
                throw new IllegalArgumentException("File is too long:" + byArray.length + " max is:" + this.m_aFile.length);
            }
            Arrays.fill(this.m_aFile, (byte)0);
            System.arraycopy(byArray, 0, this.m_aFile, 0, byArray.length);
        } else {
            Arrays.fill(this.m_aFile, (byte)0);
        }
    }

    public short getFlags() {
        return this.m_nFlags;
    }

    public void setFlags(short s) {
        this.m_nFlags = s;
    }

    public InetAddress getGiaddr() {
        try {
            return InetAddress.getByAddress(this.getGiaddrRaw());
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public byte[] getGiaddrRaw() {
        return (byte[])this.m_aGiaddr.clone();
    }

    public void setGiaddr(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setGiaddrRaw(inetAddress.getAddress());
    }

    public void setGiaddr(String string) throws UnknownHostException {
        this.setGiaddr(InetAddress.getByName(string));
    }

    public void setGiaddrRaw(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(byArray, 0, this.m_aGiaddr, 0, 4);
    }

    public byte getHlen() {
        return this.m_nHlen;
    }

    public void setHlen(byte by) {
        this.m_nHlen = by;
    }

    public byte getHops() {
        return this.m_nHops;
    }

    public void setHops(byte by) {
        this.m_nHops = by;
    }

    public byte getHtype() {
        return this.m_nHtype;
    }

    public void setHtype(byte by) {
        this.m_nHtype = by;
    }

    public boolean isDhcp() {
        return this.m_bIsDhcp;
    }

    public void setDhcp(boolean bl) {
        this.m_bIsDhcp = bl;
    }

    public byte getOp() {
        return this.m_nOp;
    }

    public void setOp(byte by) {
        this.m_nOp = by;
    }

    public byte[] getPadding() {
        return (byte[])this.m_aPadding.clone();
    }

    public void setPadding(byte[] byArray) {
        this.m_aPadding = byArray == null ? new byte[]{} : (byte[])byArray.clone();
    }

    public void setPaddingWithZeroes(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 1500) {
            throw new IllegalArgumentException("length is > 1500");
        }
        this.setPadding(new byte[n2]);
    }

    public short getSecs() {
        return this.m_nSecs;
    }

    public void setSecs(short s) {
        this.m_nSecs = s;
    }

    public InetAddress getSiaddr() {
        try {
            return InetAddress.getByAddress(this.getSiaddrRaw());
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public byte[] getSiaddrRaw() {
        return (byte[])this.m_aSiaddr.clone();
    }

    public void setSiaddr(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setSiaddrRaw(inetAddress.getAddress());
    }

    public void setSiaddr(String string) throws UnknownHostException {
        this.setSiaddr(InetAddress.getByName(string));
    }

    public void setSiaddrRaw(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(byArray, 0, this.m_aSiaddr, 0, 4);
    }

    public byte[] getSnameRaw() {
        return (byte[])this.m_aSname.clone();
    }

    public String getSname() {
        return Util.bytesToString(this.getSnameRaw());
    }

    public void setSname(String string) {
        this.setSnameRaw(Util.stringToBytes(string));
    }

    public void setSnameRaw(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length > this.m_aSname.length) {
                throw new IllegalArgumentException("Sname is too long:" + byArray.length + " max is:" + this.m_aSname.length);
            }
            Arrays.fill(this.m_aSname, (byte)0);
            System.arraycopy(byArray, 0, this.m_aSname, 0, byArray.length);
        } else {
            Arrays.fill(this.m_aSname, (byte)0);
        }
    }

    public int getXid() {
        return this.m_nXid;
    }

    public void setXid(int n) {
        this.m_nXid = n;
    }

    public InetAddress getYiaddr() {
        try {
            return InetAddress.getByAddress(this.getYiaddrRaw());
        }
        catch (UnknownHostException unknownHostException) {
            s_aLogger.error("Unexpected UnknownHostException", (Throwable)unknownHostException);
            return null;
        }
    }

    public byte[] getYiaddrRaw() {
        return (byte[])this.m_aYiaddr.clone();
    }

    public void setYiaddr(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Inet4Address required");
        }
        this.setYiaddrRaw(inetAddress.getAddress());
    }

    public void setYiaddr(String string) throws UnknownHostException {
        this.setYiaddr(InetAddress.getByName(string));
    }

    public void setYiaddrRaw(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("4-byte array required");
        }
        System.arraycopy(byArray, 0, this.m_aYiaddr, 0, 4);
    }

    public Byte getDHCPMessageType() {
        return this.getOptionAsByte((byte)53);
    }

    public void setDHCPMessageType(byte by) {
        this.setOptionAsByte((byte)53, by);
    }

    public boolean isTruncated() {
        return this.m_bTruncated;
    }

    public Integer getOptionAsNum(byte by) {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption != null ? dHCPOption.getValueAsNum() : null;
    }

    public Byte getOptionAsByte(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : Byte.valueOf(dHCPOption.getValueAsByte());
    }

    public Short getOptionAsShort(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : Short.valueOf(dHCPOption.getValueAsShort());
    }

    public Integer getOptionAsInteger(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : Integer.valueOf(dHCPOption.getValueAsInt());
    }

    public InetAddress getOptionAsInetAddr(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueAsInetAddr();
    }

    public String getOptionAsString(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueAsString();
    }

    public short[] getOptionAsShorts(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueAsShorts();
    }

    public InetAddress[] getOptionAsInetAddrs(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueAsInetAddrs();
    }

    public byte[] getOptionAsBytes(byte by) throws IllegalArgumentException {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueAsBytes();
    }

    public void setOptionAsByte(byte by, byte by2) {
        this.setOption(DHCPOption.newOptionAsByte(by, by2));
    }

    public void setOptionAsShort(byte by, short s) {
        this.setOption(DHCPOption.newOptionAsShort(by, s));
    }

    public void setOptionAsInt(byte by, int n) {
        this.setOption(DHCPOption.newOptionAsInt(by, n));
    }

    public void setOptionAsInetAddress(byte by, InetAddress inetAddress) {
        this.setOption(DHCPOption.newOptionAsInetAddress(by, inetAddress));
    }

    public void setOptionAsInetAddress(byte by, String string) throws UnknownHostException {
        this.setOption(DHCPOption.newOptionAsInetAddress(by, InetAddress.getByName(string)));
    }

    public void setOptionAsInetAddresses(byte by, InetAddress[] inetAddressArray) {
        this.setOption(DHCPOption.newOptionAsInetAddresses(by, inetAddressArray));
    }

    public void setOptionAsString(byte by, String string) {
        this.setOption(DHCPOption.newOptionAsString(by, string));
    }

    public byte[] getOptionRaw(byte by) {
        DHCPOption dHCPOption = this.getOption(by);
        return dHCPOption == null ? null : dHCPOption.getValueFast();
    }

    public DHCPOption getOption(byte by) {
        DHCPOption dHCPOption = this.m_aOptions.get(by);
        if (dHCPOption == null) {
            return null;
        }
        assert (dHCPOption.getCode() == by);
        assert (dHCPOption.getValueFast() != null);
        return dHCPOption;
    }

    public boolean containsOption(byte by) {
        return this.m_aOptions.containsKey(by);
    }

    public Collection<DHCPOption> getOptionsCollection() {
        return Collections.unmodifiableCollection(this.m_aOptions.values());
    }

    public DHCPOption[] getOptionsArray() {
        return this.m_aOptions.values().toArray(new DHCPOption[this.m_aOptions.size()]);
    }

    public void setOptionRaw(byte by, byte[] byArray) {
        if (byArray == null) {
            this.removeOption(by);
        } else {
            this.setOption(new DHCPOption(by, byArray));
        }
    }

    public void setOption(DHCPOption dHCPOption) {
        if (dHCPOption != null) {
            if (dHCPOption.getValueFast() == null) {
                this.removeOption(dHCPOption.getCode());
            } else {
                this.m_aOptions.put(dHCPOption.getCode(), dHCPOption);
            }
        }
    }

    public void setOptions(DHCPOption[] dHCPOptionArray) {
        if (dHCPOptionArray != null) {
            for (DHCPOption dHCPOption : dHCPOptionArray) {
                this.setOption(dHCPOption);
            }
        }
    }

    public void setOptions(Collection<DHCPOption> collection) {
        if (collection != null) {
            for (DHCPOption dHCPOption : collection) {
                this.setOption(dHCPOption);
            }
        }
    }

    public void removeOption(byte by) {
        this.m_aOptions.remove(by);
    }

    public void removeAllOptions() {
        this.m_aOptions.clear();
    }

    public InetAddress getAddress() {
        return this.m_aAddress;
    }

    public void setAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            this.m_aAddress = null;
        } else {
            if (!(inetAddress instanceof Inet4Address)) {
                throw new IllegalArgumentException("only IPv4 addresses accepted");
            }
            this.m_aAddress = inetAddress;
        }
    }

    public int getPort() {
        return this.m_nPort;
    }

    public void setPort(int n) {
        this.m_nPort = n;
    }

    public InetSocketAddress getAddrPort() {
        return new InetSocketAddress(this.m_aAddress, this.m_nPort);
    }

    public void setAddrPort(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            this.setAddress(null);
            this.setPort(0);
        } else {
            this.setAddress(inetSocketAddress.getAddress());
            this.setPort(inetSocketAddress.getPort());
        }
    }
}

