/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.config;

import java.io.File;
import java.io.IOException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.surveillanceViews.SurveillanceViewConfiguration;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewProvider.class);
    private static SurveillanceViewProvider m_surveillanceViewProvider;
    private SurveillanceViewConfiguration m_surveillanceViewConfiguration = null;
    private File m_cfgFile;

    private SurveillanceViewProvider() {
        this.load();
    }

    public static SurveillanceViewProvider getInstance() {
        if (m_surveillanceViewProvider == null) {
            m_surveillanceViewProvider = new SurveillanceViewProvider();
        }
        return m_surveillanceViewProvider;
    }

    public synchronized void save() {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        try {
            JaxbUtils.marshal((Object)this.m_surveillanceViewConfiguration, (File)this.m_cfgFile);
        }
        catch (IOException e) {
            String filename = ConfigFileConstants.getFileName((int)ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME);
            LOG.error("Unable to save {}", (Object)filename, (Object)e);
            throw new IllegalStateException("Unable to save " + filename, e);
        }
    }

    public synchronized void load() {
        LOG.debug("Loading surveillance view configuration.");
        if (this.m_cfgFile == null) {
            try {
                this.m_cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME);
            }
            catch (IOException e) {
                LOG.error("Unable to load {}", (Object)ConfigFileConstants.getFileName((int)ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME));
                this.m_cfgFile = new File(System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "surveillance-views.xml");
            }
        }
        LOG.debug("Using surveillance view file: {}", (Object)this.m_cfgFile);
        if (!this.m_cfgFile.exists()) {
            LOG.warn("Surveillance view configuration {} does not exist!", (Object)this.m_cfgFile);
            this.m_surveillanceViewConfiguration = new SurveillanceViewConfiguration();
        } else {
            this.m_surveillanceViewConfiguration = (SurveillanceViewConfiguration)JaxbUtils.unmarshal(SurveillanceViewConfiguration.class, (File)this.m_cfgFile);
        }
        LOG.debug("Surveillance view configuration loaded: {}", (Object)this.m_surveillanceViewConfiguration);
    }

    public synchronized boolean containsView(String name) {
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized View getView(String name) {
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(name)) continue;
            return view;
        }
        return null;
    }

    public synchronized void replaceView(View oldView, View newView) {
        View viewFound = null;
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(oldView.getName())) continue;
            viewFound = view;
            break;
        }
        if (viewFound != null) {
            int index = this.getSurveillanceViewConfiguration().getViews().indexOf(viewFound);
            this.getSurveillanceViewConfiguration().getViews().set(index, newView);
        }
    }

    public synchronized View getDefaultView() {
        String defaultView = this.m_surveillanceViewConfiguration.getDefaultView();
        return this.getView(defaultView);
    }

    public SurveillanceViewConfiguration getSurveillanceViewConfiguration() {
        return this.m_surveillanceViewConfiguration;
    }

    public synchronized boolean containsView(View view) {
        return this.m_surveillanceViewConfiguration.getViews().contains(view);
    }

    public synchronized void addView(View view) {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        this.m_surveillanceViewConfiguration.getViews().add(view);
        this.save();
    }

    public synchronized void removeView(View view) {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        this.m_surveillanceViewConfiguration.getViews().remove(view);
        this.save();
    }
}

