/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.graph.Edge;
import org.opennms.integration.api.v1.graph.VertexRef;
import org.opennms.integration.api.v1.graph.immutables.ImmutableElement;
import org.opennms.integration.api.v1.graph.immutables.ImmutableVertexRef;

public final class ImmutableEdge
extends ImmutableElement
implements Edge {
    private final VertexRef source;
    private final VertexRef target;

    private ImmutableEdge(Builder builder) {
        super(builder.properties);
        this.source = ImmutableVertexRef.immutableCopy(builder.source);
        this.target = ImmutableVertexRef.immutableCopy(builder.target);
        Objects.requireNonNull(this.source, "source cannot be null.");
        Objects.requireNonNull(this.target, "target cannot be null.");
        Objects.requireNonNull(this.getId(), "id cannot be null");
        Objects.requireNonNull(this.getNamespace(), "namespace cannot be null");
    }

    public String getNamespace() {
        return (String)this.getProperty("namespace");
    }

    public String getId() {
        return (String)this.getProperty("id");
    }

    public VertexRef getSource() {
        return this.source;
    }

    public VertexRef getTarget() {
        return this.target;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableEdge that = (ImmutableEdge)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.target);
    }

    @Override
    public String toString() {
        return "ImmutableEdge{source=" + this.source + ", target=" + this.target + ", properties=" + this.properties + "}";
    }

    public static Builder newBuilder(String namespace, String id, VertexRef source, VertexRef target) {
        return new Builder().namespace(namespace).id(id).source(source).target(target);
    }

    public static Builder newBuilderFrom(Edge fromEdge) {
        VertexRef sourceCopy = ImmutableVertexRef.immutableCopy(fromEdge.getSource());
        VertexRef targetCopy = ImmutableVertexRef.immutableCopy(fromEdge.getSource());
        return ((Builder)new Builder().properties(fromEdge.getProperties())).source(sourceCopy).target(targetCopy);
    }

    public static Edge immutableCopy(Edge edge) {
        if (edge == null || edge instanceof ImmutableEdge) {
            return edge;
        }
        return ImmutableEdge.newBuilderFrom(edge).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableElement.AbstractBuilder<Builder> {
        private VertexRef source;
        private VertexRef target;

        private Builder() {
        }

        public Builder namespace(String namespace) {
            Objects.requireNonNull(namespace, "namespace cannot be null.");
            this.property("namespace", namespace);
            return this;
        }

        public Builder id(String id) {
            this.property("id", id);
            return this;
        }

        public Builder label(String label) {
            this.property("label", label);
            return this;
        }

        public Builder source(String namespace, String id) {
            VertexRef sourceVertexRef = ImmutableVertexRef.newBuilder(namespace, id).build();
            this.source(sourceVertexRef);
            return this;
        }

        public Builder source(VertexRef source) {
            Objects.requireNonNull(source);
            this.source = source;
            return this;
        }

        public Builder target(String namespace, String id) {
            VertexRef targetVertexRef = ImmutableVertexRef.newBuilder(namespace, id).build();
            this.target(targetVertexRef);
            return this;
        }

        public Builder target(VertexRef target) {
            Objects.requireNonNull(target);
            this.target = target;
            return this;
        }

        public ImmutableEdge build() {
            return new ImmutableEdge(this);
        }
    }
}

