/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.newts.api.Duration;

public class Timestamp
implements Comparable<Timestamp>,
Serializable {
    private static final long serialVersionUID = 8827895112055791967L;
    public final long m_time;
    public final TimeUnit m_unit;

    public Timestamp(long time, TimeUnit unit) {
        this.m_time = time;
        this.m_unit = unit;
    }

    private long convert(TimeUnit unit) {
        return unit.convert(this.m_time, this.m_unit);
    }

    public long asSeconds() {
        return this.convert(TimeUnit.SECONDS);
    }

    public long asMillis() {
        return this.convert(TimeUnit.MILLISECONDS);
    }

    public Date asDate() {
        return new Date(this.convert(TimeUnit.MILLISECONDS));
    }

    public TimeUnit getUnit() {
        return this.m_unit;
    }

    public Timestamp plus(long value, TimeUnit units) {
        TimeUnit finest = Timestamp.finest(this.m_unit, units);
        return new Timestamp(this.convert(finest) + finest.convert(value, units), finest);
    }

    public Timestamp plus(Duration d) {
        TimeUnit finest = Timestamp.finest(this.m_unit, d.getUnit());
        return new Timestamp(this.convert(finest) + d.convert(finest), finest);
    }

    public Timestamp minus(long value, TimeUnit units) {
        TimeUnit finest = Timestamp.finest(this.m_unit, units);
        return new Timestamp(this.convert(finest) - finest.convert(value, units), finest);
    }

    public Timestamp minus(Duration d) {
        TimeUnit finest = Timestamp.finest(this.m_unit, d.getUnit());
        return new Timestamp(this.convert(finest) - d.convert(finest), finest);
    }

    public Duration minus(Timestamp t) {
        if (t.gt(this)) {
            throw new IllegalArgumentException("you can only subtract an earlier date from a later one... negative durations don't make sense");
        }
        TimeUnit finest = Timestamp.finest(this.m_unit, t.getUnit());
        return new Duration(this.convert(finest) - t.convert(finest), finest);
    }

    public boolean lt(Timestamp other) {
        return this.compareTo(other) < 0;
    }

    public boolean lte(Timestamp other) {
        return this.lt(other) || this.equals(other);
    }

    public boolean gt(Timestamp other) {
        return this.compareTo(other) > 0;
    }

    public boolean gte(Timestamp other) {
        return this.gt(other) || this.equals(other);
    }

    public Timestamp stepFloor(long stepSize, TimeUnit units) {
        return new Timestamp(this.convert(units) / stepSize * stepSize, units);
    }

    public Timestamp stepFloor(Duration d) {
        return this.stepFloor(d.getDuration(), d.getUnit());
    }

    public Timestamp stepCeiling(long stepSize, TimeUnit units) {
        long v = this.convert(units);
        return v % stepSize == 0L ? new Timestamp(v, units) : new Timestamp((v / stepSize + 1L) * stepSize, units);
    }

    public Timestamp stepCeiling(Duration d) {
        return this.stepCeiling(d.getDuration(), d.getUnit());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Timestamp)) {
            return false;
        }
        return this.compareTo((Timestamp)other) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.convert(TimeUnit.NANOSECONDS));
    }

    @Override
    public int compareTo(Timestamp o) {
        TimeUnit unit = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.convert(unit) < o.convert(unit) ? -1 : (this.convert(unit) > o.convert(unit) ? 1 : 0);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.asDate());
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public static Timestamp fromEpochMillis(long millis) {
        return new Timestamp(millis, TimeUnit.MILLISECONDS);
    }

    public static Timestamp fromEpochSeconds(long seconds) {
        return new Timestamp(seconds, TimeUnit.SECONDS);
    }

    public static Timestamp fromDate(Date d) {
        return Timestamp.fromEpochMillis(d.getTime());
    }

    static boolean isFiner(TimeUnit unit1, TimeUnit unit2) {
        long c = unit2.convert(1L, unit1);
        return c == 0L;
    }

    static TimeUnit finest(TimeUnit unit1, TimeUnit unit2) {
        return Timestamp.isFiner(unit1, unit2) ? unit1 : unit2;
    }
}

