/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.shell;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.ipc.common.kafka.Utils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="opennms", name="kafka-producer-topics", description="Show status of all Kafka producer topics.")
@Service
public class KafkaProducerTopics
implements Action {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String STATUS_OK = "[OK]";
    private static final String STATUS_MISSING = "[MISSING]";
    private static final String PRODUCER_CONFIG_PID = "org.opennms.features.kafka.producer";
    private static final String EVENT_TOPIC_PROP = "eventTopic";
    private static final String ALARM_TOPIC_PROP = "alarmTopic";
    private static final String NODE_TOPIC_PROP = "nodeTopic";
    private static final String METRIC_TOPIC_PROP = "metricTopic";
    private static final String TOPOLOGY_VERTEX_TOPIC_PROP = "topologyVertexTopic";
    private static final String TOPOLOGY_EDGE_TOPIC_PROP = "topologyEdgeTopic";
    private static final String ALARM_FEEDBACK_TOPIC_PROP = "alarmFeedbackTopic";
    private static final String DEFAULT_EVENT_TOPIC = "events";
    private static final String DEFAULT_ALARM_TOPIC = "alarms";
    private static final String DEFAULT_NODE_TOPIC = "nodes";
    private static final String DEFAULT_METRIC_TOPIC = "metrics";
    private static final String DEFAULT_TOPOLOGY_VERTEX_TOPIC = "vertices";
    private static final String DEFAULT_TOPOLOGY_EDGE_TOPIC = "edges";
    private static final String DEFAULT_ALARM_FEEDBACK_TOPIC = "alarmFeedback";
    @Reference
    private ConfigurationAdmin configAdmin;
    @Option(name="-t", aliases={"--timeout"}, description="Connection timeout for Kafka Server (ms)")
    private int timeout;

    /*
     * WARNING - void declaration
     */
    public Object execute() throws Exception {
        void var7_12;
        System.out.println("\nKafka Producer Topics Status");
        System.out.println("============================\n");
        Properties producerConfig = this.getProducerConfig();
        LinkedHashMap<String, String> topicNames = new LinkedHashMap<String, String>();
        topicNames.put(EVENT_TOPIC_PROP, this.getTopicName(producerConfig, EVENT_TOPIC_PROP, DEFAULT_EVENT_TOPIC));
        topicNames.put(ALARM_TOPIC_PROP, this.getTopicName(producerConfig, ALARM_TOPIC_PROP, DEFAULT_ALARM_TOPIC));
        topicNames.put(NODE_TOPIC_PROP, this.getTopicName(producerConfig, NODE_TOPIC_PROP, DEFAULT_NODE_TOPIC));
        topicNames.put(METRIC_TOPIC_PROP, this.getTopicName(producerConfig, METRIC_TOPIC_PROP, DEFAULT_METRIC_TOPIC));
        topicNames.put(TOPOLOGY_VERTEX_TOPIC_PROP, this.getTopicName(producerConfig, TOPOLOGY_VERTEX_TOPIC_PROP, DEFAULT_TOPOLOGY_VERTEX_TOPIC));
        topicNames.put(TOPOLOGY_EDGE_TOPIC_PROP, this.getTopicName(producerConfig, TOPOLOGY_EDGE_TOPIC_PROP, DEFAULT_TOPOLOGY_EDGE_TOPIC));
        topicNames.put(ALARM_FEEDBACK_TOPIC_PROP, this.getTopicName(producerConfig, ALARM_FEEDBACK_TOPIC_PROP, DEFAULT_ALARM_FEEDBACK_TOPIC));
        LinkedHashMap<String, String> topicToPid = new LinkedHashMap<String, String>();
        topicToPid.put(EVENT_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.events"));
        topicToPid.put(ALARM_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.alarms"));
        topicToPid.put(NODE_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.nodes"));
        topicToPid.put(METRIC_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.metrics"));
        topicToPid.put(TOPOLOGY_VERTEX_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.topology"));
        topicToPid.put(TOPOLOGY_EDGE_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.topology"));
        topicToPid.put(ALARM_FEEDBACK_TOPIC_PROP, this.getEffectivePid("org.opennms.features.kafka.producer.client.alarmFeedback"));
        HashMap pidToTopics = new HashMap();
        HashMap<String, Boolean> pidConnectivity = new HashMap<String, Boolean>();
        for (String string : topicToPid.values()) {
            Properties kafkaConfig;
            if (string == null || pidToTopics.containsKey(string) || (kafkaConfig = this.getKafkaClientConfig(string)) == null || !kafkaConfig.containsKey("bootstrap.servers")) continue;
            try {
                Set existingTopics = Utils.getTopics((Properties)kafkaConfig);
                pidToTopics.put(string, existingTopics);
                pidConnectivity.put(string, true);
            }
            catch (Exception e) {
                pidToTopics.put(string, Set.of());
                pidConnectivity.put(string, false);
            }
        }
        System.out.println("Kafka Connectivity (per configuration):");
        if (pidConnectivity.isEmpty()) {
            System.out.printf("  %-60s %s%n", "No Kafka client configuration found", STATUS_MISSING);
            return null;
        }
        for (Map.Entry entry : pidConnectivity.entrySet()) {
            String pid = (String)entry.getKey();
            boolean connected = (Boolean)entry.getValue();
            Object displayPid = pid.equals("org.opennms.features.kafka.producer.client") ? pid + " (global)" : pid;
            System.out.printf("  %-60s %s%n", displayPid, connected ? STATUS_OK : STATUS_MISSING);
        }
        System.out.println();
        System.out.println("Producer Topics:");
        int existCount = 0;
        boolean bl = false;
        for (Map.Entry entry : topicNames.entrySet()) {
            String topicProp = (String)entry.getKey();
            String topicName = (String)entry.getValue();
            String pid = (String)topicToPid.get(topicProp);
            Set existingTopics = pid != null ? pidToTopics.getOrDefault(pid, Set.of()) : Set.of();
            boolean exists = existingTopics.contains(topicName);
            String status = exists ? STATUS_OK : STATUS_MISSING;
            System.out.printf("  %-50s %s%n", topicName, status);
            if (exists) {
                ++existCount;
            }
            ++var7_12;
        }
        System.out.println();
        System.out.printf("Summary: %d of %d topics exist%n", existCount, (int)var7_12);
        return null;
    }

    private Properties getProducerConfig() {
        try {
            Configuration config = this.configAdmin.getConfiguration(PRODUCER_CONFIG_PID, null);
            if (config != null && config.getProperties() != null) {
                Properties props = new Properties();
                Dictionary dict = config.getProperties();
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Object value = dict.get(key);
                    if (value == null) continue;
                    props.setProperty(key, value.toString());
                }
                return props;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Properties getKafkaClientConfig(String pid) {
        try {
            Configuration config = this.configAdmin.getConfiguration(pid, null);
            if (config != null && config.getProperties() != null) {
                Properties props = new Properties();
                Dictionary dict = config.getProperties();
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Object value = dict.get(key);
                    if (value == null) continue;
                    props.setProperty(key, value.toString());
                }
                int effectiveTimeout = this.timeout > 0 ? this.timeout : 5000;
                props.setProperty("request.timeout.ms", String.valueOf(effectiveTimeout));
                return props;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getEffectivePid(String topicSpecificPid) {
        Properties topicConfig = this.getKafkaClientConfig(topicSpecificPid);
        if (topicConfig != null && topicConfig.containsKey("bootstrap.servers")) {
            return topicSpecificPid;
        }
        Properties globalConfig = this.getKafkaClientConfig("org.opennms.features.kafka.producer.client");
        if (globalConfig != null && globalConfig.containsKey("bootstrap.servers")) {
            return "org.opennms.features.kafka.producer.client";
        }
        return null;
    }

    private String getTopicName(Properties config, String property, String defaultValue) {
        if (config == null) {
            return defaultValue;
        }
        return config.getProperty(property, defaultValue);
    }
}

