/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.opennms.features.kafka.producer.collection.CollectionSetMapper;
import org.opennms.features.kafka.producer.model.CollectionSetProtos;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersister
implements Persister {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPersister.class);
    private static final int MAX_BUFFER_SIZE_CONFIGURED = 921600;
    private CollectionSetMapper collectionSetMapper;
    private final ServiceParameters m_params;
    private Producer<String, byte[]> producer;
    private String topicName = "metrics";
    private Boolean disableMetricsSplitting = false;

    public KafkaPersister(ServiceParameters params) {
        this.m_params = params;
    }

    public KafkaPersister() {
        this.m_params = new ServiceParameters(Collections.emptyMap());
    }

    public void visitCollectionSet(CollectionSet collectionSet) {
        CollectionSetProtos.CollectionSet collectionSetProto = this.collectionSetMapper.buildCollectionSetProtos(collectionSet, this.m_params);
        if (collectionSetProto != null) {
            this.bisectAndSendMessageToKafka(collectionSetProto);
        }
    }

    void bisectAndSendMessageToKafka(CollectionSetProtos.CollectionSet collectionSetProto) {
        if (!this.getDisableMetricsSplitting().booleanValue() && this.checkForMaxSize(collectionSetProto.toByteArray().length)) {
            if (collectionSetProto.getResourceCount() == 1) {
                CollectionSetProtos.CollectionSetResource collectionSetResource = collectionSetProto.getResource(0);
                if (collectionSetResource.getNumericList().size() > 0) {
                    CollectionSetProtos.CollectionSetResource.Builder numericResourceBuilder = CollectionSetProtos.CollectionSetResource.newBuilder();
                    numericResourceBuilder.mergeFrom(collectionSetResource).clearString();
                    CollectionSetProtos.CollectionSet collectionSetWithNumeric = CollectionSetProtos.CollectionSet.newBuilder().addResource(numericResourceBuilder).setTimestamp(collectionSetProto.getTimestamp()).build();
                    this.bisectNumericAttributes(collectionSetWithNumeric);
                }
                if (collectionSetResource.getStringList().size() > 0) {
                    CollectionSetProtos.CollectionSetResource.Builder stringResourceBuilder = CollectionSetProtos.CollectionSetResource.newBuilder();
                    stringResourceBuilder.mergeFrom(collectionSetResource).clearNumeric();
                    CollectionSetProtos.CollectionSet collectionSetWithStringAttributes = CollectionSetProtos.CollectionSet.newBuilder().addResource(stringResourceBuilder).setTimestamp(collectionSetProto.getTimestamp()).build();
                    this.bisectStringAttributes(collectionSetWithStringAttributes);
                }
            } else {
                Iterator subList = Iterables.partition(collectionSetProto.getResourceList(), (int)((collectionSetProto.getResourceCount() + 1) / 2)).iterator();
                CollectionSetProtos.CollectionSet firstPartCollectionSet = CollectionSetProtos.CollectionSet.newBuilder().mergeFrom(collectionSetProto).clearResource().addAllResource((Iterable)subList.next()).build();
                this.bisectAndSendMessageToKafka(firstPartCollectionSet);
                CollectionSetProtos.CollectionSet secondPartCollectionSet = CollectionSetProtos.CollectionSet.newBuilder().mergeFrom(collectionSetProto).clearResource().addAllResource((Iterable)subList.next()).build();
                this.bisectAndSendMessageToKafka(secondPartCollectionSet);
            }
        } else {
            this.sendMessageToKafka(collectionSetProto);
        }
    }

    private void bisectNumericAttributes(CollectionSetProtos.CollectionSet collectionSetProto) {
        if (this.checkForMaxSize(collectionSetProto.toByteArray().length)) {
            Iterator subList = Iterables.partition(collectionSetProto.getResource(0).getNumericList(), (int)((collectionSetProto.getResource(0).getNumericCount() + 1) / 2)).iterator();
            this.bisectNumericAttributes(this.buildCollectionSetWithNumericAttributes(collectionSetProto, (List)subList.next()));
            this.bisectNumericAttributes(this.buildCollectionSetWithNumericAttributes(collectionSetProto, (List)subList.next()));
        } else {
            this.sendMessageToKafka(collectionSetProto);
        }
    }

    private CollectionSetProtos.CollectionSet buildCollectionSetWithNumericAttributes(CollectionSetProtos.CollectionSet originalCollectionSet, List<CollectionSetProtos.NumericAttribute> numericAttributes) {
        CollectionSetProtos.CollectionSet.Builder collectionSetBuilder = CollectionSetProtos.CollectionSet.newBuilder().setTimestamp(originalCollectionSet.getTimestamp());
        CollectionSetProtos.CollectionSetResource.Builder collectionSetResourceBuilder = CollectionSetProtos.CollectionSetResource.newBuilder();
        collectionSetResourceBuilder.mergeFrom(originalCollectionSet.getResource(0)).clearNumeric().addAllNumeric(numericAttributes);
        collectionSetBuilder.addResource(collectionSetResourceBuilder);
        return collectionSetBuilder.build();
    }

    private void bisectStringAttributes(CollectionSetProtos.CollectionSet collectionSetProto) {
        if (this.checkForMaxSize(collectionSetProto.toByteArray().length)) {
            Iterator subList = Iterables.partition(collectionSetProto.getResource(0).getStringList(), (int)((collectionSetProto.getResource(0).getStringCount() + 1) / 2)).iterator();
            this.bisectStringAttributes(this.buildCollectionSetWithStringAttributes(collectionSetProto, (List)subList.next()));
            this.bisectStringAttributes(this.buildCollectionSetWithStringAttributes(collectionSetProto, (List)subList.next()));
        } else {
            this.sendMessageToKafka(collectionSetProto);
        }
    }

    private CollectionSetProtos.CollectionSet buildCollectionSetWithStringAttributes(CollectionSetProtos.CollectionSet originalCollectionSet, List<CollectionSetProtos.StringAttribute> stringAttributes) {
        CollectionSetProtos.CollectionSet.Builder collectionSetBuilder = CollectionSetProtos.CollectionSet.newBuilder().setTimestamp(originalCollectionSet.getTimestamp());
        CollectionSetProtos.CollectionSetResource.Builder collectionSetResourceBuilder = CollectionSetProtos.CollectionSetResource.newBuilder();
        collectionSetResourceBuilder.mergeFrom(originalCollectionSet.getResource(0)).clearString().addAllString(stringAttributes);
        collectionSetBuilder.addResource(collectionSetResourceBuilder);
        return collectionSetBuilder.build();
    }

    boolean checkForMaxSize(int length) {
        return length > 921600;
    }

    private void sendMessageToKafka(CollectionSetProtos.CollectionSet collectionSetProto) {
        if (collectionSetProto.getResourceCount() == 0) {
            return;
        }
        String key = this.deriveKeyFromCollectionSet(collectionSetProto);
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)key, (Object)collectionSetProto.toByteArray());
        this.producer.send(record, (recordMetadata, e) -> {
            if (e != null) {
                LOG.warn("Failed to send record to producer: {}.", (Object)record, (Object)e);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("persisted collection {} to kafka with key {}", (Object)collectionSetProto.toString(), (Object)key);
            }
        });
    }

    private String deriveKeyFromCollectionSet(CollectionSetProtos.CollectionSet collectionSetProto) {
        String key = "";
        if (collectionSetProto.getResourceCount() > 0) {
            CollectionSetProtos.CollectionSetResource firstResource = collectionSetProto.getResource(0);
            if (firstResource.hasResponse()) {
                key = firstResource.getResponse().getInstance();
            } else if (firstResource.hasInterface()) {
                key = Long.toString(firstResource.getInterface().getNode().getNodeId());
            } else if (firstResource.hasGeneric()) {
                key = Long.toString(firstResource.getGeneric().getNode().getNodeId());
            } else if (firstResource.hasNode()) {
                key = Long.toString(firstResource.getNode().getNodeId());
            }
        }
        return key;
    }

    public void setTopicName(String topicName) {
        if (!Strings.isNullOrEmpty((String)topicName)) {
            this.topicName = topicName;
        }
    }

    public void setProducer(Producer<String, byte[]> producer) {
        this.producer = producer;
    }

    public void setCollectionSetMapper(CollectionSetMapper collectionSetMapper) {
        this.collectionSetMapper = collectionSetMapper;
    }

    public void visitResource(CollectionResource resource) {
    }

    public void visitGroup(AttributeGroup group) {
    }

    public void visitAttribute(CollectionAttribute attribute) {
    }

    public void completeAttribute(CollectionAttribute attribute) {
    }

    public void completeGroup(AttributeGroup group) {
    }

    public void completeResource(CollectionResource resource) {
    }

    public void completeCollectionSet(CollectionSet set) {
    }

    public void persistNumericAttribute(CollectionAttribute attribute) {
    }

    public void persistStringAttribute(CollectionAttribute attribute) {
    }

    public void setDisableMetricsSplitting(Boolean disableMetricsSplitting) {
        this.disableMetricsSplitting = disableMetricsSplitting;
    }

    public Boolean getDisableMetricsSplitting() {
        return this.disableMetricsSplitting;
    }
}

