/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.ClusteredInstanceFactoryWrapper;
import net.sf.ehcache.terracotta.TerracottaCacheCluster;
import net.sf.ehcache.terracotta.TerracottaClientRejoinListener;
import net.sf.ehcache.terracotta.TerracottaClusteredInstanceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerracottaClient.class);
    private static final int REJOIN_SLEEP_MILLIS_ON_EXCEPTION = Integer.getInteger("net.sf.ehcache.rejoin.sleepMillisOnException", 5000);
    private final TerracottaClientConfiguration terracottaClientConfiguration;
    private volatile ClusteredInstanceFactory clusteredInstanceFactory;
    private final TerracottaCacheCluster cacheCluster = new TerracottaCacheCluster();
    private final RejoinWorker rejoinWorker = new RejoinWorker();
    private final TerracottaClientRejoinListener rejoinListener;

    public TerracottaClient(CacheManager cacheManager, TerracottaClientRejoinListener rejoinAction, TerracottaClientConfiguration terracottaClientConfiguration) {
        this.rejoinListener = rejoinAction;
        this.terracottaClientConfiguration = terracottaClientConfiguration;
        if (terracottaClientConfiguration != null) {
            terracottaClientConfiguration.freezeConfig();
        }
        if (this.isRejoinEnabled()) {
            TerracottaClusteredInstanceHelper.TerracottaRuntimeType type = TerracottaClusteredInstanceHelper.getInstance().getTerracottaRuntimeTypeOrNull();
            if (type == null) {
                throw new InvalidConfigurationException("Terracotta Rejoin is enabled but can't determine Terracotta Runtime. You are probably missing Terracotta jar(s).");
            }
            if (type != TerracottaClusteredInstanceHelper.TerracottaRuntimeType.EnterpriseExpress && type != TerracottaClusteredInstanceHelper.TerracottaRuntimeType.Express) {
                throw new InvalidConfigurationException("Rejoin cannot be used in Terracotta DSO mode.");
            }
            Thread rejoinThread = new Thread((Runnable)this.rejoinWorker, "Rejoin Worker Thread [cacheManager: " + cacheManager.getName() + "]");
            rejoinThread.setDaemon(true);
            rejoinThread.start();
        }
    }

    public static TerracottaConfiguration.StorageStrategy getTerracottaDefaultStrategyForCurrentRuntime(CacheConfiguration cacheConfiguration) {
        return TerracottaClusteredInstanceHelper.getInstance().getDefaultStorageStrategyForCurrentRuntime(cacheConfiguration);
    }

    private static void setTestMode(TerracottaClusteredInstanceHelper testHelper) {
        try {
            Method method = TerracottaClusteredInstanceHelper.class.getDeclaredMethod("setTestMode", TerracottaClusteredInstanceHelper.class);
            method.setAccessible(true);
            method.invoke(null, testHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClusteredInstanceFactory getClusteredInstanceFactory() {
        this.rejoinWorker.waitUntilRejoinComplete();
        return this.clusteredInstanceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs) {
        boolean created;
        this.rejoinWorker.waitUntilRejoinComplete();
        if (this.clusteredInstanceFactory != null) {
            return false;
        }
        TerracottaClient terracottaClient = this;
        synchronized (terracottaClient) {
            if (this.clusteredInstanceFactory == null) {
                this.clusteredInstanceFactory = this.createNewClusteredInstanceFactory(cacheConfigs);
                created = true;
            } else {
                created = false;
            }
        }
        return created;
    }

    public TerracottaCacheCluster getCacheCluster() {
        this.rejoinWorker.waitUntilRejoinComplete();
        if (this.clusteredInstanceFactory == null) {
            throw new CacheException("Cannot get CacheCluster as ClusteredInstanceFactory has not been initialized yet.");
        }
        return this.cacheCluster;
    }

    public synchronized void shutdown() {
        this.rejoinWorker.waitUntilRejoinComplete();
        if (this.clusteredInstanceFactory != null) {
            this.clusteredInstanceFactory.shutdown();
        }
        this.rejoinWorker.shutdown();
    }

    private synchronized ClusteredInstanceFactory createNewClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs) {
        if (this.clusteredInstanceFactory != null) {
            LOGGER.info("Shutting down old ClusteredInstanceFactory...");
            this.clusteredInstanceFactory.shutdown();
        }
        LOGGER.info("Creating new ClusteredInstanceFactory");
        ClusteredInstanceFactory factory = TerracottaClusteredInstanceHelper.getInstance().newClusteredInstanceFactory(cacheConfigs, this.terracottaClientConfiguration);
        CacheCluster underlyingCacheCluster = factory.getTopology();
        if (this.isRejoinEnabled()) {
            underlyingCacheCluster.addTopologyListener(new NodeLeftListener(this, underlyingCacheCluster.waitUntilNodeJoinsCluster()));
        }
        this.cacheCluster.setUnderlyingCacheCluster(underlyingCacheCluster);
        return new ClusteredInstanceFactoryWrapper(this, factory);
    }

    private void rejoinCluster(ClusterNode oldNode) {
        if (!this.isRejoinEnabled()) {
            return;
        }
        this.rejoinWorker.startRejoin(oldNode);
    }

    private boolean isRejoinEnabled() {
        return this.terracottaClientConfiguration != null && this.terracottaClientConfiguration.isRejoin();
    }

    private static class RejoinStatus {
        private volatile RejoinState state = RejoinState.NOT_IN_PROGRESS;

        private RejoinStatus() {
        }

        public boolean isRejoinInProgress() {
            return this.state == RejoinState.IN_PROGRESS;
        }

        public synchronized void waitUntilRejoinComplete() {
            boolean interrupted = false;
            while (this.state == RejoinState.IN_PROGRESS) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        public synchronized void rejoinStarted() {
            this.state = RejoinState.IN_PROGRESS;
            this.notifyAll();
        }

        public synchronized void rejoinComplete() {
            this.state = RejoinState.NOT_IN_PROGRESS;
            this.notifyAll();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum RejoinState {
            IN_PROGRESS,
            NOT_IN_PROGRESS;

        }
    }

    private static class NodeLeftListener
    implements ClusterTopologyListener {
        private final ClusterNode currentNode;
        private final TerracottaClient client;

        public NodeLeftListener(TerracottaClient client, ClusterNode currentNode) {
            this.client = client;
            this.currentNode = currentNode;
        }

        public void nodeLeft(ClusterNode node) {
            if (node.equals(this.currentNode)) {
                LOGGER.info("ClusterNode [id=" + node.getId() + "] left the cluster, rejoining cluster.");
                this.client.rejoinCluster(node);
            }
        }

        public void clusterOffline(ClusterNode node) {
        }

        public void clusterOnline(ClusterNode node) {
        }

        public void nodeJoined(ClusterNode node) {
        }

        public void clusterRejoined(ClusterNode oldNode, ClusterNode newNode) {
        }
    }

    private static class RejoinRequest {
        private final ClusterNode oldNode;

        public RejoinRequest(ClusterNode oldNode) {
            this.oldNode = oldNode;
        }

        public ClusterNode getRejoinOldNode() {
            return this.oldNode;
        }
    }

    private static class RejoinRequestHolder {
        private RejoinRequest outstandingRequest;

        private RejoinRequestHolder() {
        }

        public synchronized void addRejoinRequest(ClusterNode oldNode) {
            this.outstandingRequest = new RejoinRequest(oldNode);
        }

        public synchronized RejoinRequest consume() {
            if (this.outstandingRequest == null) {
                return null;
            }
            RejoinRequest rv = this.outstandingRequest;
            this.outstandingRequest = null;
            return rv;
        }

        public synchronized boolean isRejoinRequested() {
            return this.outstandingRequest != null;
        }
    }

    private class RejoinWorker
    implements Runnable {
        private final Object rejoinSync = new Object();
        private final RejoinStatus rejoinStatus = new RejoinStatus();
        private final AtomicInteger rejoinCount = new AtomicInteger();
        private final RejoinRequestHolder rejoinRequestHolder = new RejoinRequestHolder();
        private volatile boolean shutdown;
        private volatile Thread rejoinThread;

        private RejoinWorker() {
        }

        public void run() {
            this.rejoinThread = Thread.currentThread();
            while (!this.shutdown) {
                this.waitUntilRejoinRequested();
                if (this.shutdown) break;
                boolean rejoined = false;
                RejoinRequest rejoinRequest = this.rejoinRequestHolder.consume();
                while (!rejoined) {
                    try {
                        this.doRejoin(rejoinRequest);
                        rejoined = true;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught exception while trying to rejoin cluster", (Throwable)e);
                        LOGGER.info("Trying to rejoin again in 5 secs...");
                        this.sleep(REJOIN_SLEEP_MILLIS_ON_EXCEPTION);
                    }
                }
            }
        }

        private void sleep(long sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.rejoinSync;
            synchronized (object) {
                this.shutdown = true;
                this.rejoinSync.notifyAll();
            }
        }

        private void doRejoin(RejoinRequest rejoinRequest) {
            if (rejoinRequest == null) {
                return;
            }
            ClusterNode oldNodeReference = rejoinRequest.getRejoinOldNode();
            this.rejoinStatus.rejoinStarted();
            int rejoinNumber = this.rejoinCount.incrementAndGet();
            LOGGER.info("Starting Terracotta Rejoin (as client id: " + (oldNodeReference == null ? "null" : oldNodeReference.getId()) + " left the cluster) [rejoin count = " + rejoinNumber + "] ... ");
            TerracottaClient.this.rejoinListener.clusterRejoinStarted();
            TerracottaClient.this.clusteredInstanceFactory = TerracottaClient.this.createNewClusteredInstanceFactory(Collections.EMPTY_MAP);
            TerracottaClient.this.rejoinListener.clusterRejoinComplete();
            this.fireClusterRejoinedEvent(oldNodeReference);
            LOGGER.info("Rejoin Complete [rejoin count = " + rejoinNumber + "]");
            this.rejoinStatus.rejoinComplete();
        }

        private void fireClusterRejoinedEvent(ClusterNode oldNodeReference) {
            try {
                TerracottaClient.this.cacheCluster.fireNodeRejoinedEvent(oldNodeReference, TerracottaClient.this.cacheCluster.getCurrentNode());
            }
            catch (Throwable e) {
                LOGGER.error("Caught exception while firing rejoin event", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilRejoinRequested() {
            Object object = this.rejoinSync;
            synchronized (object) {
                while (!this.rejoinRequestHolder.isRejoinRequested() && !this.shutdown) {
                    try {
                        this.rejoinSync.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRejoin(ClusterNode oldNode) {
            Object object = this.rejoinSync;
            synchronized (object) {
                this.rejoinRequestHolder.addRejoinRequest(oldNode);
                this.rejoinSync.notifyAll();
            }
        }

        private void waitUntilRejoinComplete() {
            if (this.rejoinThread == Thread.currentThread()) {
                return;
            }
            if (TerracottaClient.this.isRejoinEnabled()) {
                this.rejoinStatus.waitUntilRejoinComplete();
            }
        }
    }
}

