/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteLockSync
implements Sync,
Comparable<ReadWriteLockSync> {
    private final ReentrantReadWriteLock rrwl;
    private final Lock readLock;
    private final Lock writeLock;

    public ReadWriteLockSync() {
        this(new ReentrantReadWriteLock());
    }

    public ReadWriteLockSync(ReentrantReadWriteLock lock) {
        this.rrwl = lock;
        this.readLock = this.rrwl.readLock();
        this.writeLock = this.rrwl.writeLock();
    }

    @Override
    public void lock(LockType type) {
        this.getLock(type).lock();
    }

    @Override
    public boolean tryLock(LockType type, long msec) throws InterruptedException {
        return this.getLock(type).tryLock(msec, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unlock(LockType type) {
        this.getLock(type).unlock();
    }

    private Lock getLock(LockType type) {
        switch (type) {
            case READ: {
                return this.readLock;
            }
            case WRITE: {
                return this.writeLock;
            }
        }
        throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
    }

    @Override
    public boolean isHeldByCurrentThread(LockType type) {
        switch (type) {
            case READ: {
                throw new UnsupportedOperationException("Querying of read lock is not supported.");
            }
            case WRITE: {
                return this.rrwl.isWriteLockedByCurrentThread();
            }
        }
        throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
    }

    @Override
    public int compareTo(ReadWriteLockSync o) {
        return String.valueOf(this.hashCode()).compareTo(String.valueOf(o.hashCode()));
    }
}

