/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

public class DataSourceType {
    private static final int _COUNTER = 0;
    private static final String STR_COUNTER = "COUNTER";
    public static final DataSourceType COUNTER = new DataSourceType(0);
    private static final int _ABSOLUTE = 1;
    private static final String STR_ABSOLUTE = "ABSOLUTE";
    public static final DataSourceType ABSOLUTE = new DataSourceType(1);
    private static final int _GAUGE = 2;
    private static final String STR_GAUGE = "GAUGE";
    public static final DataSourceType GAUGE = new DataSourceType(2);
    private static final int _DERIVE = 3;
    private static final String STR_DERIVE = "DERIVE";
    public static final DataSourceType DERIVE = new DataSourceType(3);
    private int type;

    private DataSourceType(int type) {
        this.type = type;
    }

    public static DataSourceType get(String s) {
        if (STR_COUNTER.equalsIgnoreCase(s)) {
            return COUNTER;
        }
        if (STR_ABSOLUTE.equalsIgnoreCase(s)) {
            return ABSOLUTE;
        }
        if (STR_GAUGE.equalsIgnoreCase(s)) {
            return GAUGE;
        }
        if (STR_DERIVE.equalsIgnoreCase(s)) {
            return DERIVE;
        }
        throw new IllegalArgumentException("Invalid DataSourceType");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataSourceType)) {
            throw new IllegalArgumentException("Not a DataSourceType");
        }
        return ((DataSourceType)obj).type == this.type;
    }

    public int hashCode() {
        return this.type * 37;
    }

    public String toString() {
        String strType;
        switch (this.type) {
            case 0: {
                strType = STR_COUNTER;
                break;
            }
            case 1: {
                strType = STR_ABSOLUTE;
                break;
            }
            case 2: {
                strType = STR_GAUGE;
                break;
            }
            case 3: {
                strType = STR_DERIVE;
                break;
            }
            default: {
                throw new RuntimeException("This should never happen");
            }
        }
        return strType;
    }
}

