/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdNioBackend;
import org.jrobin.core.SyncTimer;
import org.jrobin.core.SyncTimerTask;

public final class SyncManager {
    private int m_syncPeriod = 300;
    private Timer m_timer = null;
    private Map<RrdNioBackend, TimerTask> m_tasks = new HashMap<RrdNioBackend, TimerTask>();

    public SyncManager(int syncPeriod) {
        this.m_syncPeriod = syncPeriod;
    }

    public int getSyncPeriod() {
        return this.m_syncPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncPeriod(int syncPeriod) {
        this.m_syncPeriod = syncPeriod;
        Map<RrdNioBackend, TimerTask> map = this.m_tasks;
        synchronized (map) {
            Timer oldTimer = this.m_timer;
            this.m_timer = new SyncTimer();
            for (RrdNioBackend backend : this.m_tasks.keySet()) {
                this.m_tasks.get(backend).cancel();
                this.scheduleTask(backend);
            }
            this.cancelTimer(oldTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RrdNioBackend rrdNioBackend) {
        Map<RrdNioBackend, TimerTask> map = this.m_tasks;
        synchronized (map) {
            if (this.m_tasks.size() == 0) {
                this.m_timer = new SyncTimer();
            }
            this.scheduleTask(rrdNioBackend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RrdNioBackend rrdNioBackend) {
        Map<RrdNioBackend, TimerTask> map = this.m_tasks;
        synchronized (map) {
            TimerTask oldTask = this.m_tasks.remove(rrdNioBackend);
            if (oldTask != null) {
                oldTask.cancel();
            }
            if (this.m_tasks.size() == 0) {
                this.cancelTimer(this.m_timer);
                this.m_timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<RrdNioBackend, TimerTask> map = this.m_tasks;
        synchronized (map) {
            for (Map.Entry<RrdNioBackend, TimerTask> entry : this.m_tasks.entrySet()) {
                entry.getValue().cancel();
            }
            this.cancelTimer(this.m_timer);
        }
    }

    private void cancelTimer(Timer timer) {
        if (timer == null) {
            return;
        }
        timer.cancel();
        timer.purge();
    }

    private void scheduleTask(RrdNioBackend rrdNioBackend) {
        SyncTimerTask task = new SyncTimerTask(rrdNioBackend);
        if (this.m_tasks.containsKey(rrdNioBackend)) {
            this.m_tasks.get(rrdNioBackend).cancel();
        }
        this.m_tasks.put(rrdNioBackend, task);
        this.m_timer.schedule((TimerTask)task, (long)this.getSyncPeriod() * 1000L, (long)this.getSyncPeriod() * 1000L);
    }

    Timer getTimer() {
        return this.m_timer;
    }
}

