/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphInfo;

class RrdGraphCmd
extends RrdToolCmd
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef gdef;

    RrdGraphCmd() {
    }

    @Override
    String getCmdType() {
        return "graph";
    }

    @Override
    Object execute() throws RrdException, IOException {
        this.gdef = this.getGraphDef();
        RrdGraphInfo info = new RrdGraph(this.gdef).getRrdGraphInfo();
        if (info.getFilename().equals("-")) {
            RrdGraphCmd.println(new String(info.getBytes()));
        } else {
            String[] plines;
            RrdGraphCmd.println(info.getWidth() + "x" + info.getHeight());
            for (String pline : plines = info.getPrintLines()) {
                RrdGraphCmd.println(pline);
            }
            if (info.getImgInfo() != null && info.getImgInfo().length() > 0) {
                RrdGraphCmd.println(info.getImgInfo());
            }
        }
        return info;
    }

    public RrdGraphDef getGraphDef() throws RrdException {
        String[] words;
        RrdGraphDef gdef = new RrdGraphDef();
        String t1 = this.getOptionValue("s", "start", "end-1d");
        String t2 = this.getOptionValue("e", "end", "now");
        gdef.setTimeSpan(Util.getTimestamps(t1, t2));
        this.parseXGrid(gdef, this.getOptionValue("x", "x-grid"));
        this.parseYGrid(gdef, this.getOptionValue("y", "y-grid"));
        gdef.setAltYGrid(this.getBooleanOption("Y", "alt-y-grid"));
        gdef.setNoMinorGrid(this.getBooleanOption(null, "no-minor"));
        gdef.setAltYMrtg(this.getBooleanOption("R", "alt-y-mrtg"));
        gdef.setAltAutoscale(this.getBooleanOption("A", "alt-autoscale"));
        gdef.setAltAutoscaleMax(this.getBooleanOption("M", "alt-autoscale-max"));
        String opt = this.getOptionValue("X", "units-exponent");
        if (opt != null) {
            gdef.setUnitsExponent(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("L", "units-length")) != null) {
            gdef.setUnitsLength(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("v", "vertical-label")) != null) {
            gdef.setVerticalLabel(opt);
        }
        if ((opt = this.getOptionValue("w", "width")) != null) {
            gdef.setWidth(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("h", "height")) != null) {
            gdef.setHeight(RrdGraphCmd.parseInt(opt));
        }
        gdef.setInterlaced(this.getBooleanOption("i", "interlaced"));
        opt = this.getOptionValue("f", "imginfo");
        if (opt != null) {
            gdef.setImageInfo(opt);
        }
        if ((opt = this.getOptionValue("a", "imgformat")) != null) {
            gdef.setImageFormat(opt);
        }
        if ((opt = this.getOptionValue("B", "background")) != null) {
            gdef.setBackgroundImage(opt);
        }
        if ((opt = this.getOptionValue("O", "overlay")) != null) {
            gdef.setOverlayImage(opt);
        }
        if ((opt = this.getOptionValue("U", "unit")) != null) {
            gdef.setUnit(opt);
        }
        gdef.setLazy(this.getBooleanOption("z", "lazy"));
        opt = this.getOptionValue("u", "upper-limit");
        if (opt != null) {
            gdef.setMaxValue(RrdGraphCmd.parseDouble(opt));
        }
        if ((opt = this.getOptionValue("l", "lower-limit")) != null) {
            gdef.setMinValue(RrdGraphCmd.parseDouble(opt));
        }
        gdef.setRigid(this.getBooleanOption("r", "rigid"));
        opt = this.getOptionValue("b", "base");
        if (opt != null) {
            gdef.setBase(RrdGraphCmd.parseDouble(opt));
        }
        gdef.setLogarithmic(this.getBooleanOption("o", "logarithmic"));
        this.parseColors(gdef, this.getMultipleOptionValues("c", "color"));
        gdef.setNoLegend(this.getBooleanOption("g", "no-legend"));
        gdef.setOnlyGraph(this.getBooleanOption("j", "only-graph"));
        gdef.setForceRulesLegend(this.getBooleanOption("F", "force-rules-legend"));
        opt = this.getOptionValue("t", "title");
        if (opt != null) {
            gdef.setTitle(opt);
        }
        if ((opt = this.getOptionValue("S", "step")) != null) {
            gdef.setStep(RrdGraphCmd.parseLong(opt));
        }
        if ((words = this.getRemainingWords()).length < 2) {
            throw new RrdException("Image filename must be specified");
        }
        gdef.setFilename(words[1]);
        for (int i = 2; i < words.length; ++i) {
            if (words[i].startsWith("DEF:")) {
                this.parseDef(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("VDEF:")) {
                this.parseVDef(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("CDEF:")) {
                this.parseCDef(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("PRINT:")) {
                this.parsePrint(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("GPRINT:")) {
                this.parseGPrint(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("COMMENT:")) {
                this.parseComment(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("HRULE:")) {
                this.parseHRule(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("VRULE:")) {
                this.parseVRule(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("LINE1:") || words[i].startsWith("LINE2:") || words[i].startsWith("LINE3:")) {
                this.parseLine(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("AREA:")) {
                this.parseArea(gdef, words[i]);
                continue;
            }
            if (words[i].startsWith("STACK:")) {
                this.parseStack(gdef, words[i]);
                continue;
            }
            throw new RrdException("Unexpected GRAPH token encountered: " + words[i]);
        }
        return gdef;
    }

    private void parseLine(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new RrdException("Invalid LINE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new RrdException("Invalid LINE statement: " + word);
        }
        float width = Integer.parseInt(tokens1[0].substring(tokens1[0].length() - 1));
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        graphDef.line(name, color, legend, width);
    }

    private void parseArea(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new RrdException("Invalid AREA statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new RrdException("Invalid AREA statement: " + word);
        }
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        graphDef.area(name, color, legend);
    }

    private void parseStack(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new RrdException("Invalid STACK statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new RrdException("Invalid STACK statement: " + word);
        }
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        graphDef.stack(name, color, legend);
    }

    private void parseHRule(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length < 2 || tokens1.length > 3) {
            throw new RrdException("Invalid HRULE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid HRULE statement: " + word);
        }
        double value = RrdGraphCmd.parseDouble(tokens2[0]);
        Paint color = Util.parseColor(tokens2[1]);
        graphDef.hrule(value, color, tokens1.length == 3 ? tokens1[2] : null);
    }

    private void parseVRule(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length < 2 || tokens1.length > 3) {
            throw new RrdException("Invalid VRULE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid VRULE statement: " + word);
        }
        long timestamp = Util.getTimestamp(tokens2[0]);
        Paint color = Util.parseColor(tokens2[1]);
        graphDef.vrule(timestamp, color, tokens1.length == 3 ? tokens1[2] : null);
    }

    private void parseComment(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid COMMENT specification: " + word);
        }
        graphDef.comment(tokens[1]);
    }

    private void parseDef(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 4) {
            throw new RrdException("Invalid DEF specification: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid DEF specification: " + word);
        }
        graphDef.datasource(tokens2[0], tokens2[1], tokens1[2], tokens1[3]);
    }

    private void parseCDef(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2) {
            throw new RrdException("Invalid CDEF specification: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid DEF specification: " + word);
        }
        graphDef.datasource(tokens2[0], tokens2[1]);
    }

    private void parseVDef(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2) {
            throw new RrdException("Invalid VDEF specification: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new RrdException("Invalid DEF specification: " + word);
        }
        String[] tokens3 = tokens2[1].split(",");
        if (tokens3.length == 2) {
            graphDef.datasource(tokens2[0], tokens3[0], tokens3[1]);
        } else {
            graphDef.datasource(tokens2[0], tokens3[0], Double.parseDouble(tokens3[1]), tokens3[2].equals("PERCENT"));
        }
    }

    private void parsePrint(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 4) {
            throw new RrdException("Invalid PRINT specification: " + word);
        }
        graphDef.print(tokens[1], tokens[2], tokens[3]);
    }

    private void parseGPrint(RrdGraphDef graphDef, String word) throws RrdException {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 4) {
            throw new RrdException("Invalid GPRINT specification: " + word);
        }
        graphDef.gprint(tokens[1], tokens[2], tokens[3]);
    }

    private void parseColors(RrdGraphDef graphDef, String[] colorOptions) throws RrdException {
        if (colorOptions == null) {
            return;
        }
        for (String colorOption : colorOptions) {
            String[] tokens = colorOption.split("#");
            if (tokens.length != 2) {
                throw new RrdException("Invalid COLOR specification: " + colorOption);
            }
            String colorName = tokens[0];
            Paint paint = Util.parseColor(tokens[1]);
            graphDef.setColor(colorName, paint);
        }
    }

    private void parseYGrid(RrdGraphDef graphDef, String ygrid) throws RrdException {
        if (ygrid == null) {
            return;
        }
        if (ygrid.equalsIgnoreCase("none")) {
            graphDef.setDrawYGrid(false);
            return;
        }
        String[] tokens = new ColonSplitter(ygrid).split();
        if (tokens.length != 2) {
            throw new RrdException("Invalid YGRID settings: " + ygrid);
        }
        double gridStep = RrdGraphCmd.parseDouble(tokens[0]);
        int labelFactor = RrdGraphCmd.parseInt(tokens[1]);
        graphDef.setValueAxis(gridStep, labelFactor);
    }

    private void parseXGrid(RrdGraphDef graphDef, String xgrid) throws RrdException {
        if (xgrid == null) {
            return;
        }
        if (xgrid.equalsIgnoreCase("none")) {
            graphDef.setDrawXGrid(false);
            return;
        }
        String[] tokens = new ColonSplitter(xgrid).split();
        if (tokens.length != 8) {
            throw new RrdException("Invalid XGRID settings: " + xgrid);
        }
        int minorUnit = this.resolveUnit(tokens[0]);
        int majorUnit = this.resolveUnit(tokens[2]);
        int labelUnit = this.resolveUnit(tokens[4]);
        int minorUnitCount = RrdGraphCmd.parseInt(tokens[1]);
        int majorUnitCount = RrdGraphCmd.parseInt(tokens[3]);
        int labelUnitCount = RrdGraphCmd.parseInt(tokens[5]);
        int labelSpan = RrdGraphCmd.parseInt(tokens[6]);
        String fmt = tokens[7];
        graphDef.setTimeAxis(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, fmt);
    }

    private int resolveUnit(String unitName) throws RrdException {
        String[] unitNames = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR"};
        int[] units = new int[]{13, 12, 11, 5, 3, 2, 1};
        for (int i = 0; i < unitNames.length; ++i) {
            if (!unitName.equalsIgnoreCase(unitNames[i])) continue;
            return units[i];
        }
        throw new RrdException("Unknown time unit specified: " + unitName);
    }
}

