/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.messaging.simp.SimpAttributes;
import org.springframework.messaging.simp.SimpAttributesContextHolder;

public class SimpSessionScope
implements Scope {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        SimpAttributes simpAttributes = SimpAttributesContextHolder.currentAttributes();
        Object value = simpAttributes.getAttribute(name);
        if (value != null) {
            return value;
        }
        Object object = simpAttributes.getSessionMutex();
        synchronized (object) {
            value = simpAttributes.getAttribute(name);
            if (value == null) {
                value = objectFactory.getObject();
                simpAttributes.setAttribute(name, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        SimpAttributes simpAttributes = SimpAttributesContextHolder.currentAttributes();
        Object object = simpAttributes.getSessionMutex();
        synchronized (object) {
            Object value = simpAttributes.getAttribute(name);
            if (value != null) {
                simpAttributes.removeAttribute(name);
                return value;
            }
            return null;
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        SimpAttributesContextHolder.currentAttributes().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return SimpAttributesContextHolder.currentAttributes().getSessionId();
    }
}

